'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /* eslint-disable */


var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('Button', module).add('general', General).add('inverse', Inverse).add('monochrome', Monochrome);

var titleCell = {
    width: 150
};

var buttonCell = {
    display: 'flex',
    width: '33%',
    justifyContent: 'center'
};

var buttonRow = {
    display: 'flex', justifyContent: 'space-between', alignItems: 'center', marginTop: 10
};

function ButtonRow(props) {
    var label = props.label || 'Normal';
    var element = props.element || 'button';
    var text = props.text || 'Primary';

    var buttonProps = props.props || {};

    var layouts = ['layout-small', '', 'layout-large'];

    return _react2.default.createElement(
        'div',
        { style: buttonRow },
        _react2.default.createElement(
            'div',
            { style: titleCell },
            label
        ),
        layouts.map(function (layout) {
            return _react2.default.createElement(
                'div',
                { key: layout, className: layout, style: buttonCell },
                _react2.default.createElement(element, _extends({}, buttonProps), text)
            );
        })
    );
}

function ButtonHeader(props) {
    return _react2.default.createElement(
        'div',
        { style: { marginTop: 10 } },
        _react2.default.createElement(
            'h3',
            null,
            props.title
        ),
        _react2.default.createElement(
            'div',
            { style: buttonRow },
            _react2.default.createElement('div', { style: titleCell }),
            _react2.default.createElement(
                'div',
                { style: buttonCell },
                'Small'
            ),
            _react2.default.createElement(
                'div',
                { style: buttonCell },
                'Medium'
            ),
            _react2.default.createElement(
                'div',
                { style: buttonCell },
                'Large'
            )
        )
    );
}

function ButtonTable(props) {
    var className = props.className || '';
    var style = props.style || {};
    style.padding = 10;
    style.backgroundColor = style.backgroundColor || 'transparent';

    return _react2.default.createElement(
        'div',
        { className: className, style: style },
        props.children
    );
}

function General() {
    return _react2.default.createElement(
        ButtonTable,
        null,
        _react2.default.createElement('span', { className: 'componentdoc', 'data-docfile': 'doc-buttons-default' }),
        _react2.default.createElement(ButtonHeader, { title: 'Primary Button' }),
        _react2.default.createElement(ButtonRow, { label: 'Normal' }),
        _react2.default.createElement(ButtonRow, { label: 'Hover', props: { className: 'hover' } }),
        _react2.default.createElement(ButtonRow, { label: 'Active', props: { className: 'active' } }),
        _react2.default.createElement(ButtonRow, { label: 'Disabled', props: { disabled: true } }),
        _react2.default.createElement(ButtonRow, { label: 'Focus', props: { className: 'focus' } }),
        _react2.default.createElement(ButtonRow, { label: 'Destructive', props: { className: 'btn-danger' } }),
        _react2.default.createElement(ButtonHeader, { title: 'Secondary Button' }),
        _react2.default.createElement(ButtonRow, { label: 'Normal', text: 'Secondary', props: { className: 'btn-secondary' } }),
        _react2.default.createElement(ButtonRow, { label: 'Hover', text: 'Secondary', props: { className: 'btn-secondary hover' } }),
        _react2.default.createElement(ButtonRow, { label: 'Active', text: 'Secondary', props: { className: 'btn-secondary active' } }),
        _react2.default.createElement(ButtonRow, { label: 'Disabled', text: 'Secondary', props: { className: 'btn-secondary', disabled: true } }),
        _react2.default.createElement(ButtonRow, { label: 'Focus', text: 'Secondary', props: { className: 'btn-secondary focus' } }),
        _react2.default.createElement(ButtonRow, { label: 'Destructive', text: 'Secondary', props: { className: 'btn-secondary btn-danger' } }),
        _react2.default.createElement(ButtonHeader, { title: 'Link Button' }),
        _react2.default.createElement(ButtonRow, { label: 'Normal', element: 'a', text: 'Link Button', props: { className: 'btn-link', href: '#' } }),
        _react2.default.createElement(ButtonRow, { label: 'Hover', element: 'a', text: 'Link Button', props: { className: 'btn-link hover', href: '#' } }),
        _react2.default.createElement(ButtonRow, { label: 'Active', element: 'a', text: 'Link Button', props: { className: 'btn-link active', href: '#' } }),
        _react2.default.createElement(ButtonRow, { label: 'Focus', element: 'a', text: 'Link Button', props: { className: 'btn-link focus', href: '#' } }),
        _react2.default.createElement(ButtonHeader, { title: 'A tag as Button' }),
        _react2.default.createElement(ButtonRow, { label: 'Normal', element: 'a', text: 'Link Button', props: { className: 'btn', href: '#' } }),
        _react2.default.createElement(ButtonRow, { label: 'Hover', element: 'a', text: 'Link Button', props: { className: 'btn hover', href: '#' } }),
        _react2.default.createElement(ButtonRow, { label: 'Active', element: 'a', text: 'Link Button', props: { className: 'btn active', href: '#' } }),
        _react2.default.createElement(ButtonRow, { label: 'Focus', element: 'a', text: 'Link Button', props: { className: 'btn focus', href: '#' } })
    );
}

function Inverse() {
    return _react2.default.createElement(
        ButtonTable,
        { className: 'inverse', style: { color: '#FFF', backgroundColor: '#003054' } },
        _react2.default.createElement('span', { className: 'componentdoc', 'data-docfile': 'doc-buttons-inverse' }),
        _react2.default.createElement(ButtonHeader, { title: 'Primary' }),
        _react2.default.createElement(ButtonRow, { label: 'Normal' }),
        _react2.default.createElement(ButtonRow, { label: 'Hover', props: { className: 'hover' } }),
        _react2.default.createElement(ButtonRow, { label: 'Active', props: { className: 'active' } }),
        _react2.default.createElement(ButtonRow, { label: 'Disabled', props: { disabled: true } }),
        _react2.default.createElement(ButtonRow, { label: 'Focus', props: { className: 'focus' } }),
        _react2.default.createElement(ButtonRow, { label: 'Destructive', props: { className: 'btn-danger' } }),
        _react2.default.createElement(ButtonHeader, { title: 'Link Button' }),
        _react2.default.createElement(ButtonRow, { label: 'Normal', element: 'a', text: 'Link Button', props: { className: 'btn-link', href: '#' } }),
        _react2.default.createElement(ButtonRow, { label: 'Hover', element: 'a', text: 'Link Button', props: { className: 'btn-link hover', href: '#' } }),
        _react2.default.createElement(ButtonRow, { label: 'Active', element: 'a', text: 'Link Button', props: { className: 'btn-link active', href: '#' } }),
        _react2.default.createElement(ButtonRow, { label: 'Focus', element: 'a', text: 'Link Button', props: { className: 'btn-link focus', href: '#' } })
    );
}

function Monochrome() {
    return _react2.default.createElement(
        ButtonTable,
        { className: 'monochrome' },
        _react2.default.createElement(ButtonHeader, { title: 'Primary' }),
        _react2.default.createElement(ButtonRow, { label: 'Normal', props: { className: 'monochrome' } }),
        _react2.default.createElement(ButtonRow, { label: 'Hover', props: { className: 'monochrome hover' } }),
        _react2.default.createElement(ButtonRow, { label: 'Active', props: { className: 'monochrome active' } }),
        _react2.default.createElement(ButtonRow, { label: 'Disabled', props: { className: 'monochrome', disabled: true } }),
        _react2.default.createElement(ButtonRow, { label: 'Focus', props: { className: 'monochrome focus' } }),
        _react2.default.createElement(ButtonRow, { label: 'Destructive', props: { className: 'monochrome' } })
    );
}
//# sourceMappingURL=ButtonStories.js.map
