'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _Toast = require('../components/Toast');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('Toast', module).add('standard', scenario1).add('long text', scenario2).add('no action', scenario3).add('delay of 30s', scenario4).add('handlers', scenario5).add('within layout', scenario6).add('success', scenario7).add('error', scenario8).add('error with caption', scenario9);

function scenario1() {
    return _react2.default.createElement(_Toast.Toast, { text: 'Run Started', action: 'Open' });
}

function scenario2() {
    var text = "Extremely long text, this message is excessively long," + " but we need to keep wrapping until we get ellipsis. " + " Just add a little more text and now we should be there.";
    return _react2.default.createElement(_Toast.Toast, { text: text, action: 'Open' });
}

function scenario3() {
    return _react2.default.createElement(_Toast.Toast, { text: 'Run started' });
}

function scenario4() {
    return _react2.default.createElement(_Toast.Toast, { text: 'Run Started', action: 'Open', dismissDelay: 30000 });
}

function scenario5() {
    return _react2.default.createElement(_Toast.Toast, { text: 'Run Started', action: 'Open', dismissDelay: 0,
        onActionClick: (0, _storybook.action)('action'), onDismiss: (0, _storybook.action)('dismiss') });
}

function scenario6() {
    var styles = {
        display: 'flex',
        alignItems: 'center'
    };
    return _react2.default.createElement(
        'div',
        { style: styles },
        _react2.default.createElement(
            'span',
            null,
            'Element A'
        ),
        _react2.default.createElement(_Toast.Toast, { text: 'Run Started', action: 'Open' }),
        _react2.default.createElement(
            'span',
            null,
            'Element B'
        )
    );
}

function scenario7() {
    return _react2.default.createElement(_Toast.Toast, { text: 'Cool, that worked nicely', style: 'success' });
}

function scenario8() {
    return _react2.default.createElement(_Toast.Toast, { text: 'There was an error !!', style: 'error' });
}

function scenario9() {
    return _react2.default.createElement(_Toast.Toast, { caption: 'Favoriting Error', text: 'no default branch to favorite', style: 'error' });
}
//# sourceMappingURL=toast.js.map
