/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.echarts;

import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.echarts.BuildResult;
import hudson.model.Run;
import io.jenkins.plugins.util.BuildAction;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;

public class BuildActionIterator<T extends BuildAction<?>>
implements Iterator<BuildResult<T>> {
    private final Class<T> actionType;
    private Optional<T> latestAction;

    public BuildActionIterator(Class<T> actionType, Optional<T> baseline) {
        this.actionType = actionType;
        this.latestAction = baseline;
    }

    @Override
    public boolean hasNext() {
        return this.latestAction.isPresent();
    }

    @Override
    public BuildResult<T> next() {
        if (!this.latestAction.isPresent()) {
            throw new NoSuchElementException("There is no action available anymore. Use hasNext() before calling next().");
        }
        BuildAction buildAction = (BuildAction)this.latestAction.get();
        Run run = buildAction.getOwner();
        this.latestAction = BuildAction.getBuildActionFromHistoryStartingFrom((Run)run.getPreviousBuild(), this.actionType);
        int buildTimeInSeconds = (int)(run.getTimeInMillis() / 1000L);
        Build build = new Build(run.getNumber(), run.getDisplayName(), buildTimeInSeconds);
        return new BuildResult<BuildAction>(build, buildAction);
    }
}

