/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.okhttp.api.internals;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ProxyConfiguration;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class JenkinsProxyAuthenticator
implements Authenticator {
    private static final Logger LOGGER = Logger.getLogger(JenkinsProxyAuthenticator.class.getName());

    @Nullable
    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="Prefer SpotBugs @Nullable")
    public Request authenticate(@Nullable Route route, Response response) throws IOException {
        ProxyConfiguration proxy = Jenkins.get().getProxy();
        if (proxy == null || proxy.getUserName() == null) {
            return null;
        }
        if (response.request().header("Proxy-Authorization") != null) {
            return null;
        }
        String proxyAuthenticateHeader = response.header("Proxy-Authenticate");
        if (proxyAuthenticateHeader != null) {
            if (this.isAuthenticationSchemeSupported(proxyAuthenticateHeader)) {
                String credential = Credentials.basic((String)proxy.getUserName(), (String)Secret.toString((Secret)proxy.getSecretPassword()));
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            }
            LOGGER.warning("The proxy authentication scheme is not supported: " + proxyAuthenticateHeader);
        }
        return null;
    }

    private boolean isAuthenticationSchemeSupported(@NonNull String proxyAuthenticateHeader) {
        return proxyAuthenticateHeader.toLowerCase(Locale.ROOT).startsWith("basic");
    }
}

