/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.messages.Message;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.GroovyShellDecorator;
import org.jenkinsci.plugins.workflow.libs.ClasspathAdder;
import org.jenkinsci.plugins.workflow.libs.Library;
import org.jenkinsci.plugins.workflow.libs.Messages;

@Extension
public class LibraryDecorator
extends GroovyShellDecorator {
    public void customizeImports(CpsFlowExecution execution, ImportCustomizer ic) {
        ic.addImports(new String[]{Library.class.getName()});
    }

    public void configureCompiler(final CpsFlowExecution execution, CompilerConfiguration cc) {
        if (execution == null) {
            return;
        }
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new CompilationCustomizer(CompilePhase.CONVERSION){

            public void call(final SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                final ArrayList<String> libraries = new ArrayList<String>();
                final HashMap<String, Boolean> changelogs = new HashMap<String, Boolean>();
                new ClassCodeVisitorSupport(){

                    protected SourceUnit getSourceUnit() {
                        return source;
                    }

                    public void visitAnnotations(AnnotatedNode node) {
                        super.visitAnnotations(node);
                        for (AnnotationNode annotationNode : node.getAnnotations()) {
                            String name = annotationNode.getClassNode().getName();
                            if (!name.equals(Library.class.getCanonicalName()) && !name.equals(Library.class.getSimpleName())) continue;
                            Expression value = annotationNode.getMember("value");
                            Expression changelog = annotationNode.getMember("changelog");
                            if (value == null) {
                                source.getErrorCollector().addErrorAndContinue(Message.create((String)"@Library was missing a value", (ProcessingUnit)source));
                                continue;
                            }
                            this.processExpression(source, libraries, value, changelogs, changelog);
                        }
                    }

                    private void processExpression(SourceUnit source2, List<String> libraries2, Expression value) {
                        this.processExpression(source2, libraries2, value, null, null);
                    }

                    private void processExpression(SourceUnit source2, List<String> libraries2, Expression value, HashMap<String, Boolean> changelogs2, Expression changelog) {
                        if (value instanceof ConstantExpression) {
                            Object constantValue = ((ConstantExpression)value).getValue();
                            if (constantValue instanceof String) {
                                libraries2.add((String)constantValue);
                                if (changelog != null) {
                                    changelogs2.put((String)constantValue, (Boolean)((ConstantExpression)changelog).getValue());
                                }
                            } else {
                                source2.getErrorCollector().addErrorAndContinue(Message.create((String)("@Library value \u2018" + constantValue + "\u2019 was not a string"), (ProcessingUnit)source2));
                            }
                        } else if (value instanceof ListExpression) {
                            for (Expression element : ((ListExpression)value).getExpressions()) {
                                this.processExpression(source2, libraries2, element);
                            }
                        } else {
                            source2.getErrorCollector().addErrorAndContinue(Message.create((String)("@Library value \u2018" + value.getText() + "\u2019 was not a constant; did you mean to use the \u2018library\u2019 step instead?"), (ProcessingUnit)source2));
                        }
                    }
                }.visitClass(classNode);
                try {
                    for (ClasspathAdder adder : ExtensionList.lookup(ClasspathAdder.class)) {
                        for (ClasspathAdder.Addition addition : adder.add(execution, libraries, changelogs)) {
                            addition.addTo(execution);
                        }
                    }
                    if (!libraries.isEmpty()) {
                        throw new AbortException(Messages.LibraryDecorator_could_not_find_any_definition_of_librari(libraries));
                    }
                }
                catch (Exception x) {
                    source.getErrorCollector().addErrorAndContinue(Message.create((String)"Loading libraries failed", (ProcessingUnit)source));
                    try {
                        TaskListener listener = execution.getOwner().getListener();
                        if (x instanceof AbortException) {
                            listener.error(x.getMessage());
                        } else {
                            Functions.printStackTrace((Throwable)x, (PrintStream)listener.getLogger());
                        }
                        throw new CompilationFailedException(3, (ProcessingUnit)source);
                    }
                    catch (IOException x2) {
                        Logger.getLogger(LibraryDecorator.class.getName()).log(Level.WARNING, null, x2);
                        throw new CompilationFailedException(3, (ProcessingUnit)source, (Throwable)x);
                    }
                }
            }
        }});
    }
}

