/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingPropertyException;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.security.AccessControlled;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.scm.impl.SingleSCMSource;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.AbstractWhitelist;
import org.jenkinsci.plugins.workflow.cps.CpsCompilationErrorsException;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.libs.LibrariesAction;
import org.jenkinsci.plugins.workflow.libs.LibraryAdder;
import org.jenkinsci.plugins.workflow.libs.LibraryCachingConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryRecord;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.LibraryRetrieverDescriptor;
import org.jenkinsci.plugins.workflow.libs.LibraryStepRetrieverVerifier;
import org.jenkinsci.plugins.workflow.libs.SCMBasedRetriever;
import org.jenkinsci.plugins.workflow.libs.SCMRetriever;
import org.jenkinsci.plugins.workflow.libs.SCMSourceRetriever;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;
import org.kohsuke.groovy.sandbox.impl.Checker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class LibraryStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(LibraryStep.class.getName());
    private final String identifier;
    private Boolean changelog = true;
    private LibraryRetriever retriever;

    @DataBoundConstructor
    public LibraryStep(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public LibraryRetriever getRetriever() {
        return this.retriever;
    }

    public Boolean getChangelog() {
        return this.changelog;
    }

    @DataBoundSetter
    public void setRetriever(LibraryRetriever retriever) {
        this.retriever = retriever;
    }

    @DataBoundSetter
    public void setChangelog(Boolean changelog) {
        this.changelog = changelog;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<LoadedClasses> {
        private static final long serialVersionUID = 1L;
        private final transient LibraryStep step;

        Execution(LibraryStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected LoadedClasses run() throws Exception {
            Run run = (Run)this.getContext().get(Run.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            String[] parsed = LibraryAdder.parse(this.step.identifier);
            String name = parsed[0];
            String version = parsed[1];
            boolean trusted = false;
            Boolean changelog = this.step.getChangelog();
            LibraryCachingConfiguration cachingConfiguration = null;
            Object source = LibraryStep.class.getName() + " " + run.getExternalizableId();
            LibraryRetriever retriever = this.step.getRetriever();
            if (retriever == null) {
                block0: for (LibraryResolver resolver : ExtensionList.lookup(LibraryResolver.class)) {
                    for (LibraryConfiguration cfg : resolver.forJob(run.getParent(), Collections.singletonMap(name, version))) {
                        if (!cfg.getName().equals(name)) continue;
                        retriever = cfg.getRetriever();
                        trusted = resolver.isTrusted();
                        version = cfg.defaultedVersion(version);
                        changelog = cfg.defaultedChangelogs(changelog);
                        cachingConfiguration = cfg.getCachingConfiguration();
                        source = resolver.getClass().getName();
                        if (!(cfg instanceof LibraryResolver.ResolvedLibraryConfiguration)) continue block0;
                        source = ((LibraryResolver.ResolvedLibraryConfiguration)cfg).getSource();
                        continue block0;
                    }
                }
                if (retriever == null) {
                    throw new AbortException("No library named " + name + " found");
                }
            } else {
                if (version == null) {
                    throw new AbortException("Must specify a version for library " + name);
                }
                if (retriever instanceof SCMRetriever) {
                    this.verifyRevision(((SCMRetriever)retriever).getScm(), name, run, listener);
                } else if (retriever instanceof SCMSourceRetriever && ((SCMSourceRetriever)retriever).getScm() instanceof SingleSCMSource) {
                    this.verifyRevision(((SingleSCMSource)((SCMSourceRetriever)retriever).getScm()).getScm(), name, run, listener);
                }
            }
            String libraryPath = null;
            if (retriever instanceof SCMBasedRetriever) {
                libraryPath = ((SCMBasedRetriever)retriever).getLibraryPath();
            }
            LibraryRecord record = new LibraryRecord(name, version, trusted, changelog, cachingConfiguration, (String)source, libraryPath);
            LibrariesAction action = (LibrariesAction)run.getAction(LibrariesAction.class);
            if (action == null) {
                action = new LibrariesAction(Lists.newArrayList((Object[])new LibraryRecord[]{record}));
                run.addAction((Action)action);
            } else {
                List<LibraryRecord> libraries = action.getLibraries();
                for (LibraryRecord existing : libraries) {
                    if (!existing.name.equals(name)) continue;
                    listener.getLogger().println("Only using first definition of library " + name);
                    return new LoadedClasses(name, existing.getDirectoryName(), trusted, changelog, run);
                }
                ArrayList<LibraryRecord> newLibraries = new ArrayList<LibraryRecord>(libraries);
                newLibraries.add(record);
                run.replaceAction((Action)new LibrariesAction(newLibraries));
            }
            listener.getLogger().println("Loading library " + record.name + "@" + record.version);
            CpsFlowExecution exec = (CpsFlowExecution)this.getContext().get(FlowExecution.class);
            GroovyClassLoader loader = (trusted ? exec.getTrustedShell() : exec.getShell()).getClassLoader();
            for (URL u : LibraryAdder.retrieve(record, retriever, listener, run, (CpsFlowExecution)this.getContext().get(FlowExecution.class))) {
                loader.addURL(u);
            }
            run.save();
            return new LoadedClasses(name, record.getDirectoryName(), trusted, changelog, run);
        }

        private void verifyRevision(SCM scm, String name, Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
            for (LibraryStepRetrieverVerifier revisionVerifier : LibraryStepRetrieverVerifier.all()) {
                revisionVerifier.verify(run, listener, scm, name);
            }
        }
    }

    @Extension
    public static class LoadedClassesWhitelist
    extends AbstractWhitelist {
        public boolean permitsMethod(Method method, Object receiver, Object[] args) {
            String name = method.getName();
            return receiver instanceof LoadedClasses && method.getDeclaringClass() == GroovyObject.class && (name.equals("getProperty") || name.equals("invokeMethod"));
        }
    }

    public static final class LoadedClasses
    extends GroovyObjectSupport
    implements Serializable {
        @NonNull
        private final String library;
        private final boolean trusted;
        private final Boolean changelog;
        @NonNull
        private final String prefix;
        @CheckForNull
        private final String clazz;
        @NonNull
        private final String srcUrl;

        LoadedClasses(String library, String libraryDirectoryName, boolean trusted, Boolean changelog, Run<?, ?> run) {
            this(library, trusted, changelog, "", null, new File(run.getRootDir(), "libs/" + libraryDirectoryName + "/src").toURI().toString());
        }

        LoadedClasses(String library, boolean trusted, Boolean changelog, String prefix, String clazz, String srcUrl) {
            this.library = library;
            this.trusted = trusted;
            this.changelog = changelog;
            this.prefix = prefix;
            this.clazz = clazz;
            this.srcUrl = srcUrl;
        }

        public Object getProperty(String property) {
            if (this.clazz != null) {
                try {
                    if (LoadedClasses.isSandboxed()) {
                        return Checker.checkedGetAttribute(this.loadClass(this.prefix + this.clazz), (boolean)false, (boolean)false, (Object)property);
                    }
                    return this.loadClass(this.prefix + this.clazz).getField(property).get(null);
                }
                catch (MissingPropertyException | NoSuchFieldException throwable) {
                }
                catch (SecurityException x) {
                    throw x;
                }
                catch (Throwable x) {
                    throw new GroovyRuntimeException(x);
                }
            }
            if (property.matches("^[A-Z].*")) {
                String fullClazz = this.clazz != null ? this.clazz + "$" + property : property;
                this.loadClass(this.prefix + fullClazz);
                return new LoadedClasses(this.library, this.trusted, this.changelog, this.prefix, fullClazz, this.srcUrl);
            }
            if (this.clazz != null) {
                throw new MissingPropertyException(property, this.loadClass(this.prefix + this.clazz));
            }
            return new LoadedClasses(this.library, this.trusted, this.changelog, this.prefix + property + ".", null, this.srcUrl);
        }

        public Object invokeMethod(String name, Object _args) {
            Object[] objectArray;
            Class<?> c = this.loadClass(this.prefix + this.clazz);
            if (_args instanceof Object[]) {
                objectArray = (Object[])_args;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = _args;
            }
            Object[] args = objectArray;
            if (LoadedClasses.isSandboxed()) {
                try {
                    if (name.equals("new")) {
                        return Checker.checkedConstructor(c, (Object[])args);
                    }
                    return Checker.checkedStaticCall(c, (String)name, (Object[])args);
                }
                catch (SecurityException x) {
                    throw x;
                }
                catch (Throwable x) {
                    throw new GroovyRuntimeException(x);
                }
            }
            if (name.equals("new")) {
                return InvokerHelper.invokeConstructorOf(c, (Object)args);
            }
            return InvokerHelper.invokeStaticMethod(c, (String)name, (Object)args);
        }

        private static boolean isSandboxed() {
            return !GroovyInterceptor.getApplicableInterceptors().isEmpty();
        }

        private Class<?> loadClass(String name) {
            CpsFlowExecution exec = CpsThread.current().getExecution();
            GroovyClassLoader loader = (this.trusted ? exec.getTrustedShell() : exec.getShell()).getClassLoader();
            try {
                String srcUrlC;
                Class c = loader.loadClass(name);
                ClassLoader definingLoader = c.getClassLoader();
                if (definingLoader instanceof GroovyClassLoader.InnerLoader) {
                    definingLoader = definingLoader.getParent();
                }
                if (definingLoader != loader) {
                    throw new IllegalAccessException("cannot access " + c + " via library handle: " + definingLoader + " is not " + loader);
                }
                CodeSource codeSource = c.getProtectionDomain().getCodeSource();
                if (codeSource == null) {
                    throw new IllegalAccessException(name + " had no defined code source");
                }
                String actual = LoadedClasses.canonicalize(codeSource.getLocation().toString());
                if (!actual.startsWith(srcUrlC = LoadedClasses.canonicalize(this.srcUrl))) {
                    throw new IllegalAccessException(name + " was defined in " + actual + " which was not inside " + srcUrlC);
                }
                if (!Modifier.isPublic(c.getModifiers())) {
                    throw new IllegalAccessException(c + " is not public");
                }
                return c;
            }
            catch (MultipleCompilationErrorsException x) {
                throw new CpsCompilationErrorsException(x);
            }
            catch (ClassNotFoundException | IllegalAccessException x) {
                throw new GroovyRuntimeException((Throwable)x);
            }
        }

        private static String canonicalize(String uri) {
            if (uri.startsWith("file:/")) {
                try {
                    return Paths.get(new URI(uri)).toRealPath(new LinkOption[0]).toUri().toString();
                }
                catch (IOException | URISyntaxException x) {
                    LOGGER.log(Level.WARNING, "could not canonicalize " + uri, x);
                }
            }
            return uri;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "library";
        }

        public String getDisplayName() {
            return "Load a library on the fly";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(Run.class, TaskListener.class, FlowExecution.class);
        }

        @Restricted(value={DoNotUse.class})
        public Collection<LibraryRetrieverDescriptor> getRetrieverDescriptors() {
            return ((LibraryConfiguration.DescriptorImpl)Jenkins.get().getDescriptorByType(LibraryConfiguration.DescriptorImpl.class)).getRetrieverDescriptors();
        }

        public AutoCompletionCandidates doAutoCompleteIdentifier(@AncestorInPath ItemGroup<?> group, @QueryParameter String value) {
            TreeSet<String> names = new TreeSet<String>();
            if (group instanceof AccessControlled && ((AccessControlled)group).hasPermission(Item.EXTENDED_READ)) {
                for (LibraryResolver resolver : ExtensionList.lookup(LibraryResolver.class)) {
                    for (LibraryConfiguration cfg : resolver.suggestedConfigurations(group)) {
                        names.add(cfg.getName());
                    }
                }
            }
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            for (String name : names) {
                if (!name.startsWith(value)) continue;
                candidates.add(name);
            }
            return candidates;
        }
    }
}

