/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class AbstractGlobalLibraries
extends GlobalConfiguration {
    private List<LibraryConfiguration> libraries = new ArrayList<LibraryConfiguration>();

    protected AbstractGlobalLibraries() {
        this.load();
    }

    public abstract String getDescription();

    public List<LibraryConfiguration> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<LibraryConfiguration> libraries) {
        this.libraries = libraries;
        this.save();
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        if (Jenkins.get().hasPermission(this.getRequiredGlobalConfigPagePermission())) {
            this.setLibraries(Collections.emptyList());
            return super.configure(req, json);
        }
        return true;
    }

    static abstract class AbstractForJob
    extends LibraryResolver {
        AbstractForJob() {
        }

        @NonNull
        protected abstract AbstractGlobalLibraries getConfiguration();

        @Override
        @NonNull
        public final Collection<LibraryConfiguration> forJob(@NonNull Job<?, ?> job, @NonNull Map<String, String> libraryVersions) {
            return this.getLibraries();
        }

        @Override
        @NonNull
        public final Collection<LibraryConfiguration> fromConfiguration(@NonNull StaplerRequest2 request) {
            if (Jenkins.get().hasPermission(this.getConfiguration().getRequiredGlobalConfigPagePermission())) {
                return this.getLibraries();
            }
            return Collections.emptySet();
        }

        @Override
        @NonNull
        public final Collection<LibraryConfiguration> suggestedConfigurations(@NonNull ItemGroup<?> group) {
            return this.getLibraries();
        }

        private List<LibraryConfiguration> getLibraries() {
            return this.getConfiguration().getLibraries().stream().map(this::mayWrapLibrary).collect(Collectors.toList());
        }

        @NonNull
        protected abstract LibraryConfiguration mayWrapLibrary(@NonNull LibraryConfiguration var1);
    }
}

