/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.Util;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EnvironmentResolver {
    private static final int RESOLVE_VARIABLE_DEPTH_DEFAULT = 10;
    private int resolveVariablesDepth;

    public EnvironmentResolver() {
        this(10);
    }

    @VisibleForTesting
    EnvironmentResolver(int resolveVariablesDepth) {
        this.resolveVariablesDepth = resolveVariablesDepth;
    }

    public String expandEnvironmentVariables(@CheckForNull EnvVars environment, String nonExpandedValue) {
        String expanded = nonExpandedValue;
        if (environment != null && !environment.isEmpty()) {
            for (int i = 0; i < this.resolveVariablesDepth && StringUtils.isNotBlank((CharSequence)expanded); ++i) {
                String old = expanded;
                if (!old.equals(expanded = Util.replaceMacro((String)expanded, (Map)environment))) continue;
                return expanded;
            }
        }
        return expanded;
    }
}

