/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import java.io.Serializable;

public class LineRange
implements Serializable {
    private static final long serialVersionUID = -4124143085672930110L;
    private final int start;
    private final int end;

    public LineRange(int line) {
        this(line, line);
    }

    public LineRange(int start, int end) {
        if (start <= 0) {
            this.start = 0;
            this.end = 0;
        } else if (start < end) {
            this.start = start;
            this.end = end;
        } else {
            this.start = end;
            this.end = start;
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isSingleLine() {
        return this.start == this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineRange lineRange = (LineRange)o;
        if (this.start != lineRange.start) {
            return false;
        }
        return this.end == lineRange.end;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        return result;
    }

    public String toString() {
        return String.format("[%d-%d]", this.start, this.end);
    }
}

