/*
 * Decompiled with CFR 0.152.
 */
package io.jmnarloch.spring.cloud.ribbon.support;

import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import io.jmnarloch.spring.cloud.ribbon.rule.DiscoveryEnabledRule;
import io.jmnarloch.spring.cloud.ribbon.rule.MetadataAwareRule;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnClass(value={DiscoveryEnabledNIWSServerList.class})
@AutoConfigureBefore(value={RibbonClientConfiguration.class})
@ConditionalOnProperty(value={"ribbon.filter.metadata.enabled"}, matchIfMissing=true)
public class RibbonDiscoveryRuleAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public DiscoveryEnabledRule metadataAwareRule() {
        return new MetadataAwareRule();
    }
}

