/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.KarateException;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepRuntime;
import com.intuit.karate.report.ReportUtils;
import java.util.HashMap;
import java.util.Map;

public class Result {
    private static final String PASSED = "passed";
    private static final String FAILED = "failed";
    private static final String SKIPPED = "skipped";
    private static final boolean INCLUDE_METHOD_KARATE_JSON = Boolean.parseBoolean(System.getProperty("karate.config.result.result-method.include"));
    private final String status;
    private final long durationNanos;
    private final boolean aborted;
    private final Throwable error;
    private final boolean skipped;
    private final StepRuntime.MethodMatch matchingMethod;
    private final long startTime;
    private final long endTime;

    public Map<String, Object> toCucumberJson() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.error == null ? 2 : 3);
        map.put("status", this.status);
        map.put("duration", this.durationNanos);
        if (this.error != null) {
            map.put("error_message", this.error.getMessage());
        }
        return map;
    }

    public static Result fromKarateJson(Map<String, Object> map) {
        String jsonMatchingMethod;
        Long startTime = (Long)map.get("startTime");
        if (startTime == null) {
            startTime = System.currentTimeMillis();
        }
        String status = (String)map.get("status");
        Number num = (Number)map.get("nanos");
        long durationNanos = num == null ? 0L : num.longValue();
        String errorMessage = (String)map.get("errorMessage");
        KarateException error = errorMessage == null ? null : new KarateException(errorMessage);
        Boolean aborted = (Boolean)map.get("aborted");
        if (aborted == null) {
            aborted = false;
        }
        StepRuntime.MethodMatch matchingMethod = null;
        if (INCLUDE_METHOD_KARATE_JSON && (jsonMatchingMethod = (String)map.get("matchingMethod")) != null) {
            matchingMethod = StepRuntime.MethodMatch.getBySignatureAndArgs(jsonMatchingMethod);
        }
        return new Result(startTime, status, durationNanos, error, aborted, matchingMethod);
    }

    public Map<String, Object> toKarateJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", this.status);
        map.put("millis", this.getDurationMillis());
        map.put("nanos", this.durationNanos);
        map.put("startTime", this.startTime);
        map.put("endTime", this.endTime);
        if (this.error != null) {
            map.put("errorMessage", this.error.getMessage());
        }
        if (this.aborted) {
            map.put("aborted", true);
        }
        if (INCLUDE_METHOD_KARATE_JSON && this.matchingMethod != null) {
            map.put("matchingMethod", this.matchingMethod.toString());
        }
        return map;
    }

    private Result(long startTime, String status, long nanos, Throwable error, boolean aborted, StepRuntime.MethodMatch matchingMethod) {
        this.startTime = startTime;
        this.status = status;
        this.durationNanos = nanos;
        this.endTime = startTime + Math.round(ReportUtils.nanosToMillis(nanos));
        this.error = error;
        this.aborted = aborted;
        this.matchingMethod = matchingMethod;
        this.skipped = SKIPPED.equals(status);
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean isFailed() {
        return this.error != null;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public Throwable getError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.error == null ? null : this.error.getMessage();
    }

    public static Result passed(long startTime, long nanos) {
        return Result.passed(startTime, nanos, null);
    }

    public static Result passed(long startTime, long nanos, StepRuntime.MethodMatch matchingMethod) {
        return new Result(startTime, PASSED, nanos, null, false, matchingMethod);
    }

    public static Result failed(long startTime, long nanos, Throwable error, Step step) {
        return Result.failed(startTime, nanos, error, step, null);
    }

    public static Result failed(long startTime, long nanos, Throwable error, Step step, StepRuntime.MethodMatch matchingMethod) {
        Object message = error.getMessage();
        if (message == null) {
            message = "" + error;
        }
        error = new KarateException((String)message + "\n" + step.getDebugInfo());
        StackTraceElement[] newTrace = new StackTraceElement[]{new StackTraceElement("<feature>", ": " + step.getPrefix() + " " + step.getText() + " ", step.getDebugInfo(), step.getLine())};
        error.setStackTrace(newTrace);
        return new Result(startTime, FAILED, nanos, error, false, matchingMethod);
    }

    public static Result skipped(long startTime) {
        return new Result(startTime, SKIPPED, 0L, null, false, null);
    }

    public static Result aborted(long startTime, long nanos) {
        return Result.aborted(startTime, nanos, null);
    }

    public static Result aborted(long startTime, long nanos, StepRuntime.MethodMatch matchingMethod) {
        return new Result(startTime, PASSED, nanos, null, true, matchingMethod);
    }

    public String getStatus() {
        return this.status;
    }

    public long getDurationNanos() {
        return this.durationNanos;
    }

    public double getDurationMillis() {
        return ReportUtils.nanosToMillis(this.durationNanos);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public StepRuntime.MethodMatch getMatchingMethod() {
        return this.matchingMethod;
    }

    public String toString() {
        return this.status;
    }
}

