/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.Config;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Variable;
import java.util.HashMap;
import java.util.Map;

public class ScenarioCall {
    public final ScenarioRuntime parentRuntime;
    public final int depth;
    public final FeatureCall featureCall;
    public final Variable arg;
    private boolean callonce;
    private boolean sharedScope;
    private boolean karateConfigDisabled;
    private int loopIndex = -1;

    public Map<String, Variable> getParentVars(boolean shallowCopy) {
        if (this.parentRuntime == null) {
            return new HashMap<String, Variable>();
        }
        ScenarioEngine mockEngine = this.parentRuntime.featureRuntime.getMockEngine();
        if (mockEngine != null) {
            if (shallowCopy) {
                return mockEngine.shallowCloneVariables();
            }
            return mockEngine.vars;
        }
        if (shallowCopy) {
            return this.parentRuntime.engine.shallowCloneVariables();
        }
        return this.parentRuntime.engine.vars;
    }

    public Config getParentConfig(boolean copy) {
        if (this.parentRuntime == null) {
            return new Config();
        }
        Config temp = this.parentRuntime.engine.getConfig();
        return copy ? new Config(temp) : temp;
    }

    public boolean isNone() {
        return this.depth == 0;
    }

    public int getLoopIndex() {
        return this.loopIndex;
    }

    public void setLoopIndex(int loopIndex) {
        this.loopIndex = loopIndex;
    }

    public void setSharedScope(boolean sharedScope) {
        this.sharedScope = sharedScope;
    }

    public boolean isSharedScope() {
        return this.sharedScope;
    }

    public boolean isCallonce() {
        return this.callonce;
    }

    public void setCallonce(boolean callonce) {
        this.callonce = callonce;
    }

    public void setKarateConfigDisabled(boolean karateConfigDisabled) {
        this.karateConfigDisabled = karateConfigDisabled;
    }

    public boolean isKarateConfigDisabled() {
        return this.karateConfigDisabled;
    }

    public static ScenarioCall none(Map<String, Object> arg) {
        return new ScenarioCall(null, null, arg == null ? null : new Variable(arg));
    }

    public ScenarioCall(ScenarioRuntime parentRuntime, FeatureCall featureCall, Variable arg) {
        this.parentRuntime = parentRuntime;
        this.featureCall = featureCall;
        this.depth = parentRuntime == null ? 0 : parentRuntime.caller.depth + 1;
        this.arg = arg;
    }

    public static class Result {
        public final Variable value;
        public final Config config;
        public final Map<String, Variable> vars;

        public Result(Variable value, Config config, Map<String, Variable> vars) {
            this.value = value;
            this.config = config;
            this.vars = vars;
        }
    }
}

