/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.Http;
import com.intuit.karate.KarateException;
import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverRunner;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.MissingElement;
import com.intuit.karate.driver.Target;
import com.intuit.karate.driver.appium.AndroidDriver;
import com.intuit.karate.driver.appium.IosDriver;
import com.intuit.karate.driver.chrome.Chrome;
import com.intuit.karate.driver.chrome.ChromeWebDriver;
import com.intuit.karate.driver.firefox.GeckoWebDriver;
import com.intuit.karate.driver.microsoft.EdgeChromium;
import com.intuit.karate.driver.microsoft.IeWebDriver;
import com.intuit.karate.driver.microsoft.MsEdgeDriver;
import com.intuit.karate.driver.microsoft.MsWebDriver;
import com.intuit.karate.driver.microsoft.WinAppDriver;
import com.intuit.karate.driver.playwright.PlaywrightDriver;
import com.intuit.karate.driver.safari.SafariWebDriver;
import com.intuit.karate.shell.Command;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DriverOptions {
    public final Map<String, Object> options;
    public final int timeout;
    public final boolean start;
    public final boolean stop;
    public final String executable;
    public final String type;
    public final int port;
    public final String host;
    public final int pollAttempts;
    public final int pollInterval;
    public final boolean headless;
    public final boolean showProcessLog;
    public final boolean showDriverLog;
    public final boolean showBrowserLog;
    public final Logger logger;
    public final LogAppender appender;
    public final Logger processLogger;
    public final Logger driverLogger;
    public final String uniqueName;
    public final File workingDir;
    public final String userAgent;
    public final String userDataDir;
    public final String processLogFile;
    public final int maxPayloadSize;
    public final List<String> addOptions;
    public final List<String> args = new ArrayList<String>();
    public final String webDriverUrl;
    public final String webDriverPath;
    public final Map<String, Object> webDriverSession;
    public final Map<String, Object> httpConfig;
    public final boolean remoteHost;
    public final boolean useDockerHost;
    public final Target target;
    public final String beforeStart;
    public final String afterStop;
    public final String videoFile;
    public final boolean highlight;
    public final int highlightDuration;
    public final String attach;
    public final boolean screenshotOnFailure;
    public final String playwrightUrl;
    public final Map<String, Object> playwrightOptions;
    private boolean retryEnabled;
    private Integer retryInterval = null;
    private Integer retryCount = null;
    private String preSubmitHash = null;
    private Integer timeoutOverride;
    public static final String SCROLL_JS_FUNCTION = "function(e){ var d = window.getComputedStyle(e).display; while(d == 'none'){ e = e.parentElement; d = window.getComputedStyle(e).display } e.scrollIntoView({block: 'center'}) }";
    public static final String KARATE_REF_GENERATOR = "function(e){ if (!document._karate) document._karate = { seq: (new Date()).getTime() }; var ref = 'ref' + document._karate.seq++; document._karate[ref] = e; return ref }";
    private static final String DOCUMENT = "document";
    private static final String HIGHLIGHT_FN = "function(e){ var old = e.getAttribute('style'); e.setAttribute('style', 'background: yellow; border: 2px solid red;'); setTimeout(function(){ e.setAttribute('style', old) }, %d) }";

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public String getPreSubmitHash() {
        return this.preSubmitHash;
    }

    public boolean isRemoteHost() {
        return this.remoteHost;
    }

    public boolean isHostDockerHost() {
        return this.host.equalsIgnoreCase("host.docker.internal");
    }

    public void setPreSubmitHash(String preSubmitHash) {
        this.preSubmitHash = preSubmitHash;
    }

    private <T> T get(String key, T defaultValue) {
        Object temp = this.options.get(key);
        return (T)(temp == null ? defaultValue : temp);
    }

    public DriverOptions(Map<String, Object> options, ScenarioRuntime sr, int defaultPort, String defaultExecutable) {
        this.options = options;
        this.appender = sr.logAppender;
        this.logger = new Logger(this.getClass());
        this.logger.setAppender(this.appender);
        this.timeout = this.get("timeout", 30000);
        this.type = this.get("type", null);
        this.start = this.get("start", true);
        this.stop = this.get("stop", true);
        this.executable = this.get("executable", defaultExecutable);
        this.headless = this.get("headless", false);
        this.showProcessLog = this.get("showProcessLog", false);
        this.showBrowserLog = this.get("showBrowserLog", true);
        this.addOptions = this.get("addOptions", null);
        this.uniqueName = this.type + "_" + System.currentTimeMillis();
        String packageName = this.getClass().getPackage().getName();
        this.processLogger = this.showProcessLog ? this.logger : new Logger(packageName + "." + this.uniqueName);
        this.showDriverLog = this.get("showDriverLog", false);
        Logger logger = this.driverLogger = this.showDriverLog ? this.logger : new Logger(packageName + "." + this.uniqueName);
        if (this.executable != null) {
            if (this.executable.startsWith(".")) {
                this.args.add(new File(this.executable).getAbsolutePath());
            } else {
                this.args.add(this.executable);
            }
        }
        this.userAgent = this.get("userAgent", null);
        if (options.containsKey("userDataDir")) {
            String temp = this.get("userDataDir", null);
            if (temp != null) {
                this.workingDir = new File(temp);
                this.userDataDir = this.workingDir.getAbsolutePath();
            } else {
                this.userDataDir = null;
                this.workingDir = null;
            }
        } else {
            this.workingDir = new File(sr.featureRuntime.suite.buildDir + File.separator + this.uniqueName);
            this.userDataDir = this.workingDir.getAbsolutePath();
        }
        this.processLogFile = this.workingDir == null ? sr.featureRuntime.suite.buildDir + File.separator + this.uniqueName + ".log" : this.workingDir.getPath() + File.separator + this.type + ".log";
        this.maxPayloadSize = this.get("maxPayloadSize", 0x400000);
        this.target = this.get("target", null);
        this.host = this.get("host", "localhost");
        this.webDriverUrl = this.get("webDriverUrl", null);
        this.webDriverPath = this.get("webDriverPath", null);
        this.webDriverSession = this.get("webDriverSession", null);
        this.httpConfig = this.get("httpConfig", null);
        this.remoteHost = this.get("remoteHost", false);
        this.useDockerHost = this.get("useDockerHost", false);
        this.beforeStart = this.get("beforeStart", null);
        this.afterStop = this.get("afterStop", null);
        this.videoFile = this.get("videoFile", null);
        this.pollAttempts = this.get("pollAttempts", 20);
        this.pollInterval = this.get("pollInterval", 250);
        this.highlight = this.get("highlight", false);
        this.highlightDuration = this.get("highlightDuration", 3000);
        this.attach = this.get("attach", null);
        this.screenshotOnFailure = this.get("screenshotOnFailure", true);
        this.playwrightUrl = this.get("playwrightUrl", null);
        this.playwrightOptions = this.get("playwrightOptions", null);
        this.port = this.resolvePort(defaultPort);
    }

    private int resolvePort(int defaultPort) {
        if (this.webDriverUrl != null) {
            return 0;
        }
        int preferredPort = this.get("port", defaultPort);
        if (this.start) {
            int freePort = Command.getFreePort(preferredPort);
            if (freePort != preferredPort) {
                this.logger.warn("preferred port {} not available, will use: {}", preferredPort, freePort);
            }
            return freePort;
        }
        return preferredPort;
    }

    public Http getHttp() {
        Http http = Http.to(this.getUrlBase());
        if (this.isRemoteHost()) {
            http.header("HOST", "localhost");
        }
        http.setAppender(this.driverLogger.getAppender());
        if (this.httpConfig != null) {
            http.configure(this.httpConfig);
        }
        return http;
    }

    private String getUrlBase() {
        if (this.webDriverUrl != null) {
            return this.webDriverUrl;
        }
        String urlBase = "http://" + this.host + ":" + this.port;
        if (this.webDriverPath != null) {
            return urlBase + this.webDriverPath;
        }
        return urlBase;
    }

    public void arg(String arg) {
        this.args.add(arg);
    }

    public Command startProcess() {
        return this.startProcess(null);
    }

    public Command startProcess(Consumer<String> listener) {
        Command command;
        if (this.beforeStart != null) {
            Command.execLine(null, this.beforeStart);
        }
        if (this.target != null || !this.start) {
            command = null;
        } else {
            if (this.addOptions != null) {
                this.args.addAll(this.addOptions);
            }
            command = new Command(false, this.processLogger, this.uniqueName, this.processLogFile, this.workingDir, this.args.toArray(new String[this.args.size()]));
            if (listener != null) {
                command.setListener(listener);
            }
            command.setPollAttempts(this.pollAttempts);
            command.setPollInterval(this.pollInterval);
            command.start();
        }
        if (command != null) {
            command.waitForPort(this.host, this.port);
            if (command.isFailed()) {
                throw new KarateException("start failed", command.getFailureReason());
            }
        }
        return command;
    }

    public static Driver start(Map<String, Object> options, ScenarioRuntime sr) {
        String type;
        Target target = (Target)options.get("target");
        if (target != null) {
            sr.logger.debug("custom target configured, calling start()", new Object[0]);
            Map<String, Object> map = target.start(sr);
            sr.logger.trace("custom target returned options: {}", map);
            options.putAll(map);
        }
        if ((type = (String)options.get("type")) == null) {
            sr.logger.warn("type was null, defaulting to 'chrome'", new Object[0]);
            type = "chrome";
            options.put("type", type);
        }
        try {
            DriverRunner driverRunner;
            Map<String, DriverRunner> drivers = sr.featureRuntime.suite.drivers;
            if (drivers == null) {
                drivers = DriverOptions.driverRunners();
            }
            if ((driverRunner = drivers.get(type)) == null) {
                sr.logger.warn("unknown driver type: {}, defaulting to 'chrome'", type);
                options.put("type", "chrome");
                driverRunner = sr.featureRuntime.suite.drivers.get("chrome");
            }
            return driverRunner.start(options, sr);
        }
        catch (Exception e) {
            String message = "driver config / start failed: " + e.getMessage() + ", options: " + options;
            sr.logger.error(message, e);
            if (target != null) {
                target.stop(sr);
            }
            throw new RuntimeException(message, e);
        }
    }

    public static Map<String, DriverRunner> driverRunners() {
        HashMap<String, DriverRunner> driverRunners = new HashMap<String, DriverRunner>();
        driverRunners.put("chrome", Chrome::start);
        driverRunners.put("msedge", EdgeChromium::start);
        driverRunners.put("chromedriver", ChromeWebDriver::start);
        driverRunners.put("geckodriver", GeckoWebDriver::start);
        driverRunners.put("safaridriver", SafariWebDriver::start);
        driverRunners.put("msedgedriver", MsEdgeDriver::start);
        driverRunners.put("mswebdriver", MsWebDriver::start);
        driverRunners.put("iedriver", IeWebDriver::start);
        driverRunners.put("winappdriver", WinAppDriver::start);
        driverRunners.put("android", AndroidDriver::start);
        driverRunners.put("ios", IosDriver::start);
        driverRunners.put("playwright", PlaywrightDriver::start);
        return driverRunners;
    }

    private Map<String, Object> getSession(String browserName) {
        HashMap capabilities;
        Map<String, Object> session = this.webDriverSession;
        if (session == null) {
            session = new HashMap<String, Object>();
        }
        if ((capabilities = (HashMap)session.get("capabilities")) == null) {
            capabilities = (Map)session.get("desiredCapabilities");
        }
        if (capabilities == null) {
            capabilities = new HashMap();
            session.put("capabilities", capabilities);
            HashMap<String, String> alwaysMatch = new HashMap<String, String>();
            capabilities.put("alwaysMatch", alwaysMatch);
            alwaysMatch.put("browserName", browserName);
        }
        return session;
    }

    public Map<String, Object> getWebDriverSessionPayload() {
        switch (this.type) {
            case "chromedriver": {
                return this.getSession("chrome");
            }
            case "geckodriver": {
                return this.getSession("firefox");
            }
            case "safaridriver": {
                return this.getSession("safari");
            }
            case "msedgedriver": 
            case "mswebdriver": {
                return this.getSession("edge");
            }
            case "iedriver": {
                return this.getSession("internet explorer");
            }
        }
        return this.getSession(this.type);
    }

    public static String preProcessWildCard(String locator) {
        int index;
        Object tag;
        String prefix;
        boolean contains;
        int pos = locator.indexOf(125);
        if (pos == -1) {
            throw new RuntimeException("bad locator prefix: " + locator);
        }
        if (locator.charAt(1) == '^') {
            contains = true;
            prefix = locator.substring(2, pos);
        } else {
            contains = false;
            prefix = locator.substring(1, pos);
        }
        String text = locator.substring(pos + 1);
        pos = prefix.indexOf(58);
        if (pos != -1) {
            String tagTemp = prefix.substring(0, pos);
            tag = tagTemp.isEmpty() ? "*" : tagTemp;
            String indexTemp = prefix.substring(pos + 1);
            if (indexTemp.isEmpty()) {
                index = 0;
            } else {
                try {
                    index = Integer.valueOf(indexTemp);
                }
                catch (Exception e) {
                    throw new RuntimeException("bad locator prefix: " + locator + ", " + e.getMessage());
                }
            }
        } else {
            tag = prefix.isEmpty() ? "*" : prefix;
            index = 0;
        }
        if (!((String)tag).startsWith("/")) {
            tag = "//" + (String)tag;
        }
        String xpath = contains ? (String)tag + "[contains(normalize-space(text()),'" + text + "')]" : (String)tag + "[normalize-space(text())='" + text + "']";
        if (index == 0) {
            return xpath;
        }
        return "/(" + xpath + ")[" + index + "]";
    }

    public static String selector(String locator) {
        return DriverOptions.selector(locator, DOCUMENT);
    }

    public static String selector(String locator, String contextNode) {
        if (((String)locator).startsWith("(")) {
            return locator;
        }
        if (((String)locator).startsWith("{")) {
            locator = DriverOptions.preProcessWildCard((String)locator);
        }
        if (((String)locator).startsWith("/") || ((String)locator).startsWith("./") || ((String)locator).startsWith("../")) {
            if (((String)locator).startsWith("/(")) {
                locator = DOCUMENT.equals(contextNode) ? ((String)locator).substring(1) : "(." + ((String)locator).substring(2);
            } else if (!DOCUMENT.equals(contextNode) && !((String)locator).startsWith(".")) {
                locator = "." + (String)locator;
            }
            return "document.evaluate(\"" + (String)locator + "\", " + contextNode + ", null, 9, null).singleNodeValue";
        }
        return contextNode + ".querySelector(\"" + (String)locator + "\")";
    }

    public void setTimeout(Integer timeout) {
        this.timeoutOverride = timeout;
    }

    public int getTimeout() {
        if (this.timeoutOverride != null) {
            return this.timeoutOverride;
        }
        return this.timeout;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getRetryInterval() {
        if (this.retryInterval != null) {
            return this.retryInterval;
        }
        ScenarioEngine engine = ScenarioEngine.get();
        if (engine == null) {
            return 3000;
        }
        return engine.getConfig().getRetryInterval();
    }

    public int getRetryCount() {
        if (this.retryCount != null) {
            return this.retryCount;
        }
        ScenarioEngine engine = ScenarioEngine.get();
        if (engine == null) {
            return 3;
        }
        return ScenarioEngine.get().getConfig().getRetryCount();
    }

    public <T> T retry(Supplier<T> action, Predicate<T> condition, String logDescription, boolean failWithException) {
        T result;
        boolean success;
        long startTime = System.currentTimeMillis();
        int count = 0;
        int max = this.getRetryCount();
        do {
            if (count <= 0) continue;
            this.logger.debug("{} - retry #{}", logDescription, count);
            this.sleep();
        } while (!(success = condition.test(result = action.get())) && count++ < max);
        if (!success) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            String message = logDescription + ": failed after " + (count - 1) + " retries and " + elapsedTime + " milliseconds";
            this.logger.warn(message, new Object[0]);
            if (failWithException) {
                throw new RuntimeException(message);
            }
        }
        return result;
    }

    public static String wrapInFunctionInvoke(String text) {
        return "(function(){ " + text + " })()";
    }

    private static String highlightFn(int millis) {
        return String.format(HIGHLIGHT_FN, millis);
    }

    public String highlight(String locator, int millis) {
        String e = DriverOptions.selector(locator);
        String temp = "var e = " + e + "; var fun = " + DriverOptions.highlightFn(millis) + "; fun(e)";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    public String highlightAll(String locator, int millis) {
        return this.scriptAllSelector(locator, DriverOptions.highlightFn(millis));
    }

    public String optionSelector(String locator, String text) {
        String condition;
        boolean textEquals = text.startsWith("{}");
        boolean textContains = text.startsWith("{^}");
        if (textEquals || textContains) {
            text = text.substring(text.indexOf(125) + 1);
            condition = textContains ? "e.options[i].text.indexOf(t) !== -1" : "e.options[i].text === t";
        } else {
            condition = "e.options[i].value === t";
        }
        String e = DriverOptions.selector(locator);
        String temp = "var e = " + e + "; var t = \"" + text + "\"; for (var i = 0; i < e.options.length; ++i) if (" + condition + ") { e.options[i].selected = true; e.dispatchEvent(new Event('change')) }";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    public String optionSelector(String id, int index) {
        String e = DriverOptions.selector(id);
        String temp = "var e = " + e + "; var t = " + index + "; for (var i = 0; i < e.options.length; ++i) if (i === t) { e.options[i].selected = true; e.dispatchEvent(new Event('change')) }";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    private String fun(String expression) {
        char first = expression.charAt(0);
        switch (first) {
            case '_': {
                if (expression.contains("=>")) {
                    return expression;
                }
            }
            case '!': {
                return "function(_){ return " + expression + " }";
            }
        }
        return expression;
    }

    public String scriptSelector(String locator, String expression) {
        return this.scriptSelector(locator, expression, DOCUMENT);
    }

    public String scriptSelector(String locator, String expression, String contextNode) {
        String temp = "var fun = " + this.fun(expression) + "; var e = " + DriverOptions.selector(locator, contextNode) + "; return fun(e)";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    public String scriptAllSelector(String locator, String expression) {
        return this.scriptAllSelector(locator, expression, DOCUMENT);
    }

    public String scriptAllSelector(String locator, String expression, String contextNode) {
        if (locator.startsWith("{")) {
            locator = DriverOptions.preProcessWildCard(locator);
        }
        boolean isXpath = locator.startsWith("/") || locator.startsWith("./") || locator.startsWith("../");
        String selector = isXpath ? "document.evaluate(\"" + locator + "\", " + contextNode + ", null, 5, null)" : contextNode + ".querySelectorAll(\"" + locator + "\")";
        String temp = "var res = []; var fun = " + this.fun(expression) + "; var es = " + selector + "; ";
        temp = isXpath ? temp + "var e = null; while(e = es.iterateNext()) res.push(fun(e)); return res" : temp + "es.forEach(function(e){ res.push(fun(e)) }); return res";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    public void sleep() {
        this.sleep(this.getRetryInterval());
    }

    public void sleep(int millis) {
        if (millis == 0) {
            return;
        }
        try {
            this.processLogger.trace("sleeping for millis: {}", millis);
            Thread.sleep(millis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getRelativePositionJs(String locator) {
        String temp = "var r = " + DriverOptions.selector(locator, DOCUMENT) + ".getBoundingClientRect(); return { x: r.x, y: r.y, width: r.width, height: r.height }";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    public static String getPositionJs(String locator) {
        String temp = "var r = " + DriverOptions.selector(locator, DOCUMENT) + ".getBoundingClientRect(); var dx = window.scrollX; var dy = window.scrollY; return { x: r.x + dx, y: r.y + dy, width: r.width + dx, height: r.height + dy }";
        return DriverOptions.wrapInFunctionInvoke(temp);
    }

    public Map<String, Object> newMapWithSelectedKeys(Map<String, Object> map, String ... keys) {
        HashMap<String, Object> out = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            Object o = map.get(key);
            if (o == null) continue;
            out.put(key, o);
        }
        return out;
    }

    public void disableRetry() {
        this.retryEnabled = false;
        this.retryCount = null;
        this.retryInterval = null;
    }

    public void enableRetry(Integer count, Integer interval) {
        this.retryEnabled = true;
        this.retryCount = count;
        this.retryInterval = interval;
    }

    public Element waitUntil(Driver driver, String locator, String expression) {
        long startTime = System.currentTimeMillis();
        String js = this.scriptSelector(locator, expression);
        boolean found = driver.waitUntil(js);
        if (!found) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            throw new RuntimeException("wait failed for: " + locator + " and condition: " + expression + " after " + elapsedTime + " milliseconds");
        }
        return DriverElement.locatorExists(driver, locator);
    }

    public String waitForUrl(Driver driver, String expected) {
        return this.retry(() -> driver.getUrl(), url -> url.contains(expected), "waitForUrl", true);
    }

    public Element waitForAny(Driver driver, String ... locators) {
        long startTime = System.currentTimeMillis();
        List<String> list = Arrays.asList(locators);
        Iterator<String> iterator = list.iterator();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            String locator = iterator.next();
            String js = DriverOptions.selector(locator);
            sb.append("(").append(js).append(" != null)");
            if (!iterator.hasNext()) continue;
            sb.append(" || ");
        }
        boolean found = driver.waitUntil(sb.toString());
        this.disableRetry();
        if (!found) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            throw new RuntimeException("wait failed for: " + list + " after " + elapsedTime + " milliseconds");
        }
        if (locators.length == 1) {
            return DriverElement.locatorExists(driver, locators[0]);
        }
        for (String locator : locators) {
            Element temp = driver.optional(locator);
            if (!temp.isPresent()) continue;
            return temp;
        }
        throw new RuntimeException("unexpected wait failure for locators: " + list);
    }

    public Element optional(Driver driver, String locator) {
        String js = DriverOptions.selector(locator);
        String evalJs = js + " != null";
        Object o = driver.script(evalJs);
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            return DriverElement.locatorExists(driver, locator);
        }
        return new MissingElement(driver, locator);
    }

    public static String karateLocator(String karateRef) {
        return "(document._karate." + karateRef + ")";
    }

    public String focusJs(String locator) {
        return "var e = " + DriverOptions.selector(locator) + "; e.focus(); try { e.selectionStart = e.selectionEnd = e.value.length } catch(x) {}";
    }

    public List<Element> findAll(Driver driver, String locator) {
        List list = driver.scriptAll(locator, KARATE_REF_GENERATOR);
        ArrayList<Element> elements = new ArrayList<Element>(list.size());
        for (String karateRef : list) {
            String karateLocator = DriverOptions.karateLocator(karateRef);
            elements.add(DriverElement.locatorExists(driver, karateLocator));
        }
        return elements;
    }
}

