/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.StringUtils;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.Finder;
import java.util.Map;

public class ElementFinder
implements Finder {
    private final Driver driver;
    private final String fromLocator;
    private final Type type;
    private String tag = "INPUT";

    public ElementFinder(Driver driver, String fromLocator, Type type) {
        this.driver = driver;
        this.fromLocator = fromLocator;
        this.type = type;
    }

    private static String forLoopChunk(Type type) {
        switch (type) {
            case RIGHT: {
                return "x += s;";
            }
            case BELOW: {
                return "y += s;";
            }
            case LEFT: {
                return "x -= s;";
            }
            case ABOVE: {
                return "y -= s;";
            }
        }
        return " var a = 0.381966 * i; var x = (s + a) * Math.cos(a); var y = (s + a) * Math.sin(a);";
    }

    public static String exitCondition(String findTag) {
        String tagName;
        boolean contains;
        int pos = findTag.indexOf(125);
        if (pos == -1) {
            return "e.tagName == '" + findTag.toUpperCase() + "'";
        }
        int caretPos = findTag.indexOf(94);
        boolean bl = contains = caretPos != -1 && caretPos < pos;
        if (!contains) {
            caretPos = 0;
        }
        String suffix = (tagName = StringUtils.trimToNull(findTag.substring(caretPos + 1, pos))) == null ? "" : " && e.tagName == '" + tagName.toUpperCase() + "'";
        String findText = findTag.substring(pos + 1);
        if (contains) {
            return "e.textContent.trim().includes('" + findText + "')" + suffix;
        }
        return "e.textContent.trim() == '" + findText + "'" + suffix;
    }

    private static String findScript(Driver driver, String locator, Type type, String findTag) {
        Map<String, Object> pos = driver.position(locator, true);
        Number xNum = (Number)pos.get("x");
        Number yNum = (Number)pos.get("y");
        Number width = (Number)pos.get("width");
        Number height = (Number)pos.get("height");
        int x = xNum.intValue() + width.intValue() / 2;
        int y = yNum.intValue() + height.intValue() / 2;
        String fun = "var gen = function(e){ if (!document._karate) document._karate = { seq: (new Date()).getTime() }; var ref = 'ref' + document._karate.seq++; document._karate[ref] = e; return ref }; var o = { x: " + x + ", y: " + y + "}; var s = 10; var x = 0; var y = 0; for (var i = 0; i < 200; i++) {" + ElementFinder.forLoopChunk(type) + " var e = document.elementFromPoint(o.x + x, o.y + y); if (e && " + ElementFinder.exitCondition(findTag) + ") return gen(e);  } return null";
        return DriverOptions.wrapInFunctionInvoke(fun);
    }

    private String getDebugString() {
        return this.fromLocator + ", " + this.type + ", " + this.tag;
    }

    @Override
    public Element find() {
        String js = ElementFinder.findScript(this.driver, this.fromLocator, this.type, this.tag);
        String karateRef = (String)this.driver.script(js);
        if (karateRef == null) {
            throw new RuntimeException("unable to find: " + this.getDebugString());
        }
        return DriverElement.locatorExists(this.driver, DriverOptions.karateLocator(karateRef));
    }

    @Override
    public Element find(String tag) {
        this.tag = tag;
        return this.find();
    }

    @Override
    public String getValue() {
        return this.find().getValue();
    }

    @Override
    public Element clear() {
        return this.find().clear();
    }

    @Override
    public Element input(String value) {
        return this.find().input(value);
    }

    @Override
    public Element select(String value) {
        return this.find("select").select(value);
    }

    @Override
    public Element select(int index) {
        return this.find("select").select(index);
    }

    @Override
    public Element click() {
        return this.find().click();
    }

    @Override
    public Element highlight() {
        return this.find().highlight();
    }

    @Override
    public Element retry() {
        return this.find().retry();
    }

    @Override
    public Element retry(int count) {
        return this.find().retry(count);
    }

    @Override
    public Element retry(Integer count, Integer interval) {
        return this.find().retry(count, interval);
    }

    public static enum Type {
        RIGHT,
        LEFT,
        ABOVE,
        BELOW,
        NEAR;

    }
}

