/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.ProxyContext;
import com.intuit.karate.http.ProxyRemoteHandler;
import com.intuit.karate.http.RequestFilter;
import com.intuit.karate.http.ResponseFilter;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClientHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(ProxyClientHandler.class);
    protected final RequestFilter requestFilter;
    protected final ResponseFilter responseFilter;
    private final Map<String, ProxyRemoteHandler> REMOTE_HANDLERS = new ConcurrentHashMap<String, ProxyRemoteHandler>();
    private final Object LOCK = new Object();
    private ProxyRemoteHandler remoteHandler;
    protected Channel clientChannel;

    public ProxyClientHandler(RequestFilter requestFilter, ResponseFilter responseFilter) {
        this.requestFilter = requestFilter;
        this.responseFilter = responseFilter;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.clientChannel = ctx.channel();
    }

    protected void channelRead0(ChannelHandlerContext ctx, final FullHttpRequest request) throws Exception {
        final boolean isConnect = HttpMethod.CONNECT.equals((Object)request.method());
        final ProxyContext pc = new ProxyContext((HttpRequest)request, isConnect);
        if (this.remoteHandler == null && !isConnect) {
            this.remoteHandler = this.REMOTE_HANDLERS.get(pc.hostColonPort);
        }
        if (this.remoteHandler != null) {
            this.remoteHandler.send(request);
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(">> init: {} - {}", (Object)pc, (Object)request);
        }
        Bootstrap b = new Bootstrap();
        b.group((EventLoopGroup)new NioEventLoopGroup(4));
        b.channel(NioSocketChannel.class);
        b.handler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel remoteChannel) throws Exception {
                ChannelPipeline p = remoteChannel.pipeline();
                if (isConnect) {
                    SSLContext sslContext = HttpUtils.getSslContext(null);
                    SSLEngine remoteSslEngine = sslContext.createSSLEngine(pc.host, pc.port);
                    remoteSslEngine.setUseClientMode(true);
                    remoteSslEngine.setNeedClientAuth(false);
                    SslHandler remoteSslHandler = new SslHandler(remoteSslEngine);
                    p.addLast(new ChannelHandler[]{remoteSslHandler});
                    remoteSslHandler.handshakeFuture().addListener(rhf -> {
                        if (logger.isTraceEnabled()) {
                            logger.trace("** ssl: server handshake done: {}", (Object)remoteChannel);
                        }
                        SSLEngine clientSslEngine = sslContext.createSSLEngine();
                        clientSslEngine.setUseClientMode(false);
                        clientSslEngine.setNeedClientAuth(false);
                        SslHandler clientSslHandler = new SslHandler(clientSslEngine);
                        FullHttpResponse response = HttpUtils.connectionEstablished();
                        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                        ProxyClientHandler.this.clientChannel.eventLoop().execute(() -> this.lambda$initChannel$0((HttpResponse)response, clientSslHandler));
                        clientSslHandler.handshakeFuture().addListener(chf -> {
                            if (logger.isTraceEnabled()) {
                                logger.trace("** ssl: client handshake done: {}", (Object)ProxyClientHandler.this.clientChannel);
                            }
                            ProxyClientHandler.this.unlockAndProceed();
                        });
                        ProxyClientHandler.this.lockAndWait();
                    });
                }
                p.addLast(new ChannelHandler[]{new HttpClientCodec()});
                p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                p.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
                ProxyClientHandler.this.remoteHandler = new ProxyRemoteHandler(pc, ProxyClientHandler.this, isConnect ? null : request);
                ProxyClientHandler.this.REMOTE_HANDLERS.put(pc.hostColonPort, ProxyClientHandler.this.remoteHandler);
                p.addLast(new ChannelHandler[]{ProxyClientHandler.this.remoteHandler});
                if (logger.isTraceEnabled()) {
                    logger.trace("updated remote handlers: {}", ProxyClientHandler.this.REMOTE_HANDLERS);
                }
            }

            private /* synthetic */ void lambda$initChannel$0(HttpResponse response, SslHandler clientSslHandler) {
                ProxyClientHandler.this.clientChannel.writeAndFlush((Object)response);
                ProxyClientHandler.this.clientChannel.pipeline().addFirst(new ChannelHandler[]{clientSslHandler});
            }
        });
        ChannelFuture cf = b.connect(pc.host, pc.port);
        cf.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("** ready: {} - {}", (Object)pc, (Object)cf.channel());
                }
            } else {
                HttpUtils.flushAndClose(this.clientChannel);
            }
        }));
        if (!isConnect) {
            this.lockAndWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAndWait() throws Exception {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAndProceed() {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause.getMessage() == null) {
            cause.printStackTrace();
        } else {
            logger.error("closing proxy inbound connection: {}", (Object)cause.getMessage());
        }
        ctx.close();
        HttpUtils.flushAndClose(this.remoteHandler.remoteChannel);
    }
}

