/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.StringUtils;
import com.intuit.karate.template.KarateEngineContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.model.IText;
import org.thymeleaf.processor.element.AbstractElementModelProcessor;
import org.thymeleaf.processor.element.IElementModelStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public class KaScriptElemProcessor
extends AbstractElementModelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(KaScriptElemProcessor.class);
    protected static final String SCOPE = "scope";
    protected static final String LOCAL = "local";
    protected static final String HEAD = "head";
    protected static final String NOCACHE = "nocache";

    public KaScriptElemProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, "script", false, SCOPE, true, 1000);
    }

    protected void doProcess(ITemplateContext ctx, IModel model, IElementModelStructureHandler sh) {
        int depth = ctx.getElementStack().size();
        IProcessableElementTag tag = (IProcessableElementTag)ctx.getElementStack().get(depth - 1);
        String scope = tag.getAttributeValue(this.getDialectPrefix(), SCOPE);
        int n = model.size();
        while (n-- != 0) {
            String text;
            ITemplateEvent event = model.get(n);
            if (!(event instanceof IText) || (text = StringUtils.trimToNull(((IText)event).getText())) == null) continue;
            if (LOCAL.equals(scope)) {
                KarateEngineContext.get().evalLocal(text, false);
                continue;
            }
            KarateEngineContext.get().evalGlobal(text);
        }
        model.reset();
    }
}

