/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.paths;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.paths.NfilesKt;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"shouldContainNFiles", "", "Ljava/nio/file/Path;", "n", "", "shouldNotContainNFiles", "containNFiles", "Lio/kotest/matchers/Matcher;", "kotest-assertions-core"})
public final class NfilesKt {
    public static final void shouldContainNFiles(@NotNull Path $this$shouldContainNFiles, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainNFiles, (String)"<this>");
        ShouldKt.should($this$shouldContainNFiles, NfilesKt.containNFiles(n));
    }

    public static final void shouldNotContainNFiles(@NotNull Path $this$shouldNotContainNFiles, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainNFiles, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotContainNFiles, NfilesKt.containNFiles(n));
    }

    @NotNull
    public static final Matcher<Path> containNFiles(int n) {
        return (Matcher)new Matcher<Path>(n){
            final /* synthetic */ int $n;
            {
                this.$n = $n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public MatcherResult test(Path value) {
                int n;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Closeable closeable = Files.newDirectoryStream(value);
                Throwable throwable = null;
                try {
                    DirectoryStream it = (DirectoryStream)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    n = CollectionsKt.count((Iterable)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                int count = n;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                return MatcherResult.Companion.invoke(Files.isDirectory(value, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && count == this.$n, () -> containNFiles.1.test$lambda$1(value, this.$n, count), () -> containNFiles.1.test$lambda$2(value, this.$n));
            }

            private static final String test$lambda$1(Path $value, int $n, int $count) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                return $value + " should be a directory and contain " + $n + " files (isDir = " + Files.isDirectory($value, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) + "; file count = " + $count + ")";
            }

            private static final String test$lambda$2(Path $value, int $n) {
                return $value + " should not be a directory containing " + $n + " files";
            }
        };
    }
}

