/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.openapi.routing.interpreters;

import io.ktor.compiler.utils.ExpressionUtilsKt;
import io.ktor.openapi.OpenApiKDocParserKt;
import io.ktor.openapi.routing.RouteField;
import io.ktor.openapi.routing.RouteFieldKt;
import io.ktor.openapi.routing.RouteNode;
import io.ktor.openapi.routing.RouteStack;
import io.ktor.openapi.routing.RouteStackKt;
import io.ktor.openapi.routing.RoutingCallInterpreter;
import io.ktor.openapi.routing.RoutingFunctionConstants;
import io.ktor.openapi.routing.RoutingReferenceResult;
import io.ktor.openapi.routing.SourceTextRange;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirEvaluatorResult;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J;\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u00020\u0006R\u00020\bR\u00020\u0013j\u0006\u0010\u0012\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lio/ktor/openapi/routing/interpreters/EndpointInterpreter;", "Lio/ktor/openapi/routing/RoutingCallInterpreter;", "<init>", "()V", "check", "Lio/ktor/openapi/routing/RoutingReferenceResult;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Lio/ktor/openapi/routing/RoutingReferenceResult;", "isRouteFunction", "", "call", "getMethod", "", "checker", "Lio/ktor/openapi/routing/RouteStack;", "stack", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lio/ktor/openapi/routing/RouteStack;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Ljava/lang/String;", "ktor-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nEndpointInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointInterpreter.kt\nio/ktor/openapi/routing/interpreters/EndpointInterpreter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class EndpointInterpreter
implements RoutingCallInterpreter {
    @Override
    @NotNull
    public RoutingReferenceResult check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!this.isRouteFunction(expression)) {
            return RoutingReferenceResult.None.INSTANCE;
        }
        SourceTextRange sourceTextRange = ExpressionUtilsKt.getLocation(context, (FirExpression)expression);
        if (sourceTextRange == null) {
            return RoutingReferenceResult.None.INSTANCE;
        }
        SourceTextRange invocation = sourceTextRange;
        RouteNode.Route routeNode = new RouteNode.Route(context.getContainingFilePath(), expression, (Function1<? super RouteStack, ? extends List<? extends RouteField>>)((Function1)arg_0 -> EndpointInterpreter.check$lambda$0(context, invocation, expression, reporter, this, arg_0)));
        return new RoutingReferenceResult.Match(routeNode);
    }

    private final boolean isRouteFunction(FirFunctionCall call) {
        return ExpressionUtilsKt.isInPackage(call, "io.ktor.server.routing") && RoutingFunctionConstants.INSTANCE.getROUTING_FUNCTION_NAMES().contains(ExpressionUtilsKt.getFunctionName(call));
    }

    private final String getMethod(CheckerContext checker, DiagnosticReporter reporter, RouteStack stack, FirFunctionCall expression) {
        String string;
        String it = string = ExpressionUtilsKt.getFunctionName(expression);
        boolean bl = false;
        String string2 = RoutingFunctionConstants.INSTANCE.getHTTP_METHODS().contains(it) ? string : null;
        if (string2 == null) {
            String string3;
            String string4;
            string = ExpressionUtilsKt.getArgument(checker, expression, "method", 1, "HttpMethod");
            if (string != null && (it = RouteStackKt.evaluate(stack, checker, reporter, (FirExpression)string)) != null && (bl = ExpressionUtilsKt.sourceText((FirEvaluatorResult)it)) != null && (string4 = StringsKt.substringAfterLast$default((String)bl, (char)'.', null, (int)2, null)) != null) {
                String string5 = string4.toLowerCase(Locale.ROOT);
                string3 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            } else {
                string3 = null;
            }
            it = string = string3;
            boolean bl2 = false;
            string2 = CollectionsKt.contains((Iterable)RoutingFunctionConstants.INSTANCE.getHTTP_METHODS(), (Object)it) ? string : null;
        }
        return string2;
    }

    private static final List check$lambda$0(CheckerContext $context, SourceTextRange $invocation, FirFunctionCall $expression, DiagnosticReporter $reporter, EndpointInterpreter this$0, RouteStack $this$Route) {
        List list;
        block1: {
            String string;
            FirEvaluatorResult firEvaluatorResult;
            Intrinsics.checkNotNullParameter((Object)$this$Route, (String)"$this$Route");
            List $this$check_u24lambda_u240_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$check_u24lambda_u240_u240.addAll((Collection)RouteFieldKt.resolveSchemaReferences($this$Route, $context, OpenApiKDocParserKt.parseKDoc($invocation)));
            FirExpression firExpression = ExpressionUtilsKt.getArgument$default($context, $expression, "path", 0, "String", 4, null);
            if (firExpression != null && (firEvaluatorResult = RouteStackKt.evaluate($this$Route, $context, $reporter, firExpression)) != null && (string = ExpressionUtilsKt.asString(firEvaluatorResult)) != null) {
                String it = string;
                boolean bl2 = false;
                $this$check_u24lambda_u240_u240.add(new RouteField.Path(it));
            }
            String string2 = this$0.getMethod($context, $reporter, $this$Route, $expression);
            if (string2 == null) break block1;
            String it = string2;
            boolean bl3 = false;
            $this$check_u24lambda_u240_u240.add(new RouteField.Method(it));
        }
        return CollectionsKt.build((List)list);
    }
}

