/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1AuditAnnotation;
import io.kubernetes.client.openapi.models.V1AuditAnnotationBuilder;
import io.kubernetes.client.openapi.models.V1AuditAnnotationFluent;
import io.kubernetes.client.openapi.models.V1MatchCondition;
import io.kubernetes.client.openapi.models.V1MatchConditionBuilder;
import io.kubernetes.client.openapi.models.V1MatchConditionFluent;
import io.kubernetes.client.openapi.models.V1MatchResources;
import io.kubernetes.client.openapi.models.V1MatchResourcesBuilder;
import io.kubernetes.client.openapi.models.V1MatchResourcesFluent;
import io.kubernetes.client.openapi.models.V1ParamKind;
import io.kubernetes.client.openapi.models.V1ParamKindBuilder;
import io.kubernetes.client.openapi.models.V1ParamKindFluent;
import io.kubernetes.client.openapi.models.V1ValidatingAdmissionPolicySpec;
import io.kubernetes.client.openapi.models.V1Validation;
import io.kubernetes.client.openapi.models.V1ValidationBuilder;
import io.kubernetes.client.openapi.models.V1ValidationFluent;
import io.kubernetes.client.openapi.models.V1Variable;
import io.kubernetes.client.openapi.models.V1VariableBuilder;
import io.kubernetes.client.openapi.models.V1VariableFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1ValidatingAdmissionPolicySpecFluent<A extends V1ValidatingAdmissionPolicySpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1AuditAnnotationBuilder> auditAnnotations;
    private String failurePolicy;
    private ArrayList<V1MatchConditionBuilder> matchConditions;
    private V1MatchResourcesBuilder matchConstraints;
    private V1ParamKindBuilder paramKind;
    private ArrayList<V1ValidationBuilder> validations;
    private ArrayList<V1VariableBuilder> variables;

    public V1ValidatingAdmissionPolicySpecFluent() {
    }

    public V1ValidatingAdmissionPolicySpecFluent(V1ValidatingAdmissionPolicySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ValidatingAdmissionPolicySpec instance) {
        V1ValidatingAdmissionPolicySpec v1ValidatingAdmissionPolicySpec = instance = instance != null ? instance : new V1ValidatingAdmissionPolicySpec();
        if (instance != null) {
            this.withAuditAnnotations(instance.getAuditAnnotations());
            this.withFailurePolicy(instance.getFailurePolicy());
            this.withMatchConditions(instance.getMatchConditions());
            this.withMatchConstraints(instance.getMatchConstraints());
            this.withParamKind(instance.getParamKind());
            this.withValidations(instance.getValidations());
            this.withVariables(instance.getVariables());
        }
    }

    public A addToAuditAnnotations(int index, V1AuditAnnotation item) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        V1AuditAnnotationBuilder builder = new V1AuditAnnotationBuilder(item);
        if (index < 0 || index >= this.auditAnnotations.size()) {
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        } else {
            this._visitables.get("auditAnnotations").add(index, builder);
            this.auditAnnotations.add(index, builder);
        }
        return (A)this;
    }

    public A setToAuditAnnotations(int index, V1AuditAnnotation item) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        V1AuditAnnotationBuilder builder = new V1AuditAnnotationBuilder(item);
        if (index < 0 || index >= this.auditAnnotations.size()) {
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        } else {
            this._visitables.get("auditAnnotations").set(index, builder);
            this.auditAnnotations.set(index, builder);
        }
        return (A)this;
    }

    public A addToAuditAnnotations(V1AuditAnnotation ... items) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        for (V1AuditAnnotation item : items) {
            V1AuditAnnotationBuilder builder = new V1AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        }
        return (A)this;
    }

    public A addAllToAuditAnnotations(Collection<V1AuditAnnotation> items) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        for (V1AuditAnnotation item : items) {
            V1AuditAnnotationBuilder builder = new V1AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        }
        return (A)this;
    }

    public A removeFromAuditAnnotations(V1AuditAnnotation ... items) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        for (V1AuditAnnotation item : items) {
            V1AuditAnnotationBuilder builder = new V1AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").remove(builder);
            this.auditAnnotations.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAuditAnnotations(Collection<V1AuditAnnotation> items) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        for (V1AuditAnnotation item : items) {
            V1AuditAnnotationBuilder builder = new V1AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").remove(builder);
            this.auditAnnotations.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAuditAnnotations(Predicate<V1AuditAnnotationBuilder> predicate) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        Iterator<V1AuditAnnotationBuilder> each = this.auditAnnotations.iterator();
        Object visitables = this._visitables.get("auditAnnotations");
        while (each.hasNext()) {
            V1AuditAnnotationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1AuditAnnotation> buildAuditAnnotations() {
        return this.auditAnnotations != null ? V1ValidatingAdmissionPolicySpecFluent.build(this.auditAnnotations) : null;
    }

    public V1AuditAnnotation buildAuditAnnotation(int index) {
        return this.auditAnnotations.get(index).build();
    }

    public V1AuditAnnotation buildFirstAuditAnnotation() {
        return this.auditAnnotations.get(0).build();
    }

    public V1AuditAnnotation buildLastAuditAnnotation() {
        return this.auditAnnotations.get(this.auditAnnotations.size() - 1).build();
    }

    public V1AuditAnnotation buildMatchingAuditAnnotation(Predicate<V1AuditAnnotationBuilder> predicate) {
        for (V1AuditAnnotationBuilder item : this.auditAnnotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAuditAnnotation(Predicate<V1AuditAnnotationBuilder> predicate) {
        for (V1AuditAnnotationBuilder item : this.auditAnnotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAuditAnnotations(List<V1AuditAnnotation> auditAnnotations) {
        if (this.auditAnnotations != null) {
            this._visitables.get("auditAnnotations").clear();
        }
        if (auditAnnotations != null) {
            this.auditAnnotations = new ArrayList();
            for (V1AuditAnnotation item : auditAnnotations) {
                this.addToAuditAnnotations(item);
            }
        } else {
            this.auditAnnotations = null;
        }
        return (A)this;
    }

    public A withAuditAnnotations(V1AuditAnnotation ... auditAnnotations) {
        if (this.auditAnnotations != null) {
            this.auditAnnotations.clear();
            this._visitables.remove("auditAnnotations");
        }
        if (auditAnnotations != null) {
            for (V1AuditAnnotation item : auditAnnotations) {
                this.addToAuditAnnotations(item);
            }
        }
        return (A)this;
    }

    public boolean hasAuditAnnotations() {
        return this.auditAnnotations != null && !this.auditAnnotations.isEmpty();
    }

    public AuditAnnotationsNested<A> addNewAuditAnnotation() {
        return new AuditAnnotationsNested(-1, null);
    }

    public AuditAnnotationsNested<A> addNewAuditAnnotationLike(V1AuditAnnotation item) {
        return new AuditAnnotationsNested(-1, item);
    }

    public AuditAnnotationsNested<A> setNewAuditAnnotationLike(int index, V1AuditAnnotation item) {
        return new AuditAnnotationsNested(index, item);
    }

    public AuditAnnotationsNested<A> editAuditAnnotation(int index) {
        if (this.auditAnnotations.size() <= index) {
            throw new RuntimeException("Can't edit auditAnnotations. Index exceeds size.");
        }
        return this.setNewAuditAnnotationLike(index, this.buildAuditAnnotation(index));
    }

    public AuditAnnotationsNested<A> editFirstAuditAnnotation() {
        if (this.auditAnnotations.size() == 0) {
            throw new RuntimeException("Can't edit first auditAnnotations. The list is empty.");
        }
        return this.setNewAuditAnnotationLike(0, this.buildAuditAnnotation(0));
    }

    public AuditAnnotationsNested<A> editLastAuditAnnotation() {
        int index = this.auditAnnotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last auditAnnotations. The list is empty.");
        }
        return this.setNewAuditAnnotationLike(index, this.buildAuditAnnotation(index));
    }

    public AuditAnnotationsNested<A> editMatchingAuditAnnotation(Predicate<V1AuditAnnotationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.auditAnnotations.size(); ++i) {
            if (!predicate.test(this.auditAnnotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching auditAnnotations. No match found.");
        }
        return this.setNewAuditAnnotationLike(index, this.buildAuditAnnotation(index));
    }

    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return (A)this;
    }

    public boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    public A addToMatchConditions(int index, V1MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get("matchConditions").add(index, builder);
            this.matchConditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToMatchConditions(int index, V1MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get("matchConditions").set(index, builder);
            this.matchConditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToMatchConditions(V1MatchCondition ... items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (V1MatchCondition item : items) {
            V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToMatchConditions(Collection<V1MatchCondition> items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (V1MatchCondition item : items) {
            V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromMatchConditions(V1MatchCondition ... items) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        for (V1MatchCondition item : items) {
            V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").remove(builder);
            this.matchConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMatchConditions(Collection<V1MatchCondition> items) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        for (V1MatchCondition item : items) {
            V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").remove(builder);
            this.matchConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMatchConditions(Predicate<V1MatchConditionBuilder> predicate) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        Iterator<V1MatchConditionBuilder> each = this.matchConditions.iterator();
        Object visitables = this._visitables.get("matchConditions");
        while (each.hasNext()) {
            V1MatchConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1MatchCondition> buildMatchConditions() {
        return this.matchConditions != null ? V1ValidatingAdmissionPolicySpecFluent.build(this.matchConditions) : null;
    }

    public V1MatchCondition buildMatchCondition(int index) {
        return this.matchConditions.get(index).build();
    }

    public V1MatchCondition buildFirstMatchCondition() {
        return this.matchConditions.get(0).build();
    }

    public V1MatchCondition buildLastMatchCondition() {
        return this.matchConditions.get(this.matchConditions.size() - 1).build();
    }

    public V1MatchCondition buildMatchingMatchCondition(Predicate<V1MatchConditionBuilder> predicate) {
        for (V1MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchCondition(Predicate<V1MatchConditionBuilder> predicate) {
        for (V1MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchConditions(List<V1MatchCondition> matchConditions) {
        if (this.matchConditions != null) {
            this._visitables.get("matchConditions").clear();
        }
        if (matchConditions != null) {
            this.matchConditions = new ArrayList();
            for (V1MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        } else {
            this.matchConditions = null;
        }
        return (A)this;
    }

    public A withMatchConditions(V1MatchCondition ... matchConditions) {
        if (this.matchConditions != null) {
            this.matchConditions.clear();
            this._visitables.remove("matchConditions");
        }
        if (matchConditions != null) {
            for (V1MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchConditions() {
        return this.matchConditions != null && !this.matchConditions.isEmpty();
    }

    public MatchConditionsNested<A> addNewMatchCondition() {
        return new MatchConditionsNested(-1, null);
    }

    public MatchConditionsNested<A> addNewMatchConditionLike(V1MatchCondition item) {
        return new MatchConditionsNested(-1, item);
    }

    public MatchConditionsNested<A> setNewMatchConditionLike(int index, V1MatchCondition item) {
        return new MatchConditionsNested(index, item);
    }

    public MatchConditionsNested<A> editMatchCondition(int index) {
        if (this.matchConditions.size() <= index) {
            throw new RuntimeException("Can't edit matchConditions. Index exceeds size.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MatchConditionsNested<A> editFirstMatchCondition() {
        if (this.matchConditions.size() == 0) {
            throw new RuntimeException("Can't edit first matchConditions. The list is empty.");
        }
        return this.setNewMatchConditionLike(0, this.buildMatchCondition(0));
    }

    public MatchConditionsNested<A> editLastMatchCondition() {
        int index = this.matchConditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchConditions. The list is empty.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MatchConditionsNested<A> editMatchingMatchCondition(Predicate<V1MatchConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchConditions.size(); ++i) {
            if (!predicate.test(this.matchConditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchConditions. No match found.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public V1MatchResources buildMatchConstraints() {
        return this.matchConstraints != null ? this.matchConstraints.build() : null;
    }

    public A withMatchConstraints(V1MatchResources matchConstraints) {
        this._visitables.remove("matchConstraints");
        if (matchConstraints != null) {
            this.matchConstraints = new V1MatchResourcesBuilder(matchConstraints);
            this._visitables.get("matchConstraints").add(this.matchConstraints);
        } else {
            this.matchConstraints = null;
            this._visitables.get("matchConstraints").remove(this.matchConstraints);
        }
        return (A)this;
    }

    public boolean hasMatchConstraints() {
        return this.matchConstraints != null;
    }

    public MatchConstraintsNested<A> withNewMatchConstraints() {
        return new MatchConstraintsNested(null);
    }

    public MatchConstraintsNested<A> withNewMatchConstraintsLike(V1MatchResources item) {
        return new MatchConstraintsNested(item);
    }

    public MatchConstraintsNested<A> editMatchConstraints() {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(null));
    }

    public MatchConstraintsNested<A> editOrNewMatchConstraints() {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(new V1MatchResourcesBuilder().build()));
    }

    public MatchConstraintsNested<A> editOrNewMatchConstraintsLike(V1MatchResources item) {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(item));
    }

    public V1ParamKind buildParamKind() {
        return this.paramKind != null ? this.paramKind.build() : null;
    }

    public A withParamKind(V1ParamKind paramKind) {
        this._visitables.remove("paramKind");
        if (paramKind != null) {
            this.paramKind = new V1ParamKindBuilder(paramKind);
            this._visitables.get("paramKind").add(this.paramKind);
        } else {
            this.paramKind = null;
            this._visitables.get("paramKind").remove(this.paramKind);
        }
        return (A)this;
    }

    public boolean hasParamKind() {
        return this.paramKind != null;
    }

    public ParamKindNested<A> withNewParamKind() {
        return new ParamKindNested(null);
    }

    public ParamKindNested<A> withNewParamKindLike(V1ParamKind item) {
        return new ParamKindNested(item);
    }

    public ParamKindNested<A> editParamKind() {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(null));
    }

    public ParamKindNested<A> editOrNewParamKind() {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(new V1ParamKindBuilder().build()));
    }

    public ParamKindNested<A> editOrNewParamKindLike(V1ParamKind item) {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(item));
    }

    public A addToValidations(int index, V1Validation item) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        V1ValidationBuilder builder = new V1ValidationBuilder(item);
        if (index < 0 || index >= this.validations.size()) {
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        } else {
            this._visitables.get("validations").add(index, builder);
            this.validations.add(index, builder);
        }
        return (A)this;
    }

    public A setToValidations(int index, V1Validation item) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        V1ValidationBuilder builder = new V1ValidationBuilder(item);
        if (index < 0 || index >= this.validations.size()) {
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        } else {
            this._visitables.get("validations").set(index, builder);
            this.validations.set(index, builder);
        }
        return (A)this;
    }

    public A addToValidations(V1Validation ... items) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        for (V1Validation item : items) {
            V1ValidationBuilder builder = new V1ValidationBuilder(item);
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        }
        return (A)this;
    }

    public A addAllToValidations(Collection<V1Validation> items) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        for (V1Validation item : items) {
            V1ValidationBuilder builder = new V1ValidationBuilder(item);
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        }
        return (A)this;
    }

    public A removeFromValidations(V1Validation ... items) {
        if (this.validations == null) {
            return (A)this;
        }
        for (V1Validation item : items) {
            V1ValidationBuilder builder = new V1ValidationBuilder(item);
            this._visitables.get("validations").remove(builder);
            this.validations.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromValidations(Collection<V1Validation> items) {
        if (this.validations == null) {
            return (A)this;
        }
        for (V1Validation item : items) {
            V1ValidationBuilder builder = new V1ValidationBuilder(item);
            this._visitables.get("validations").remove(builder);
            this.validations.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromValidations(Predicate<V1ValidationBuilder> predicate) {
        if (this.validations == null) {
            return (A)this;
        }
        Iterator<V1ValidationBuilder> each = this.validations.iterator();
        Object visitables = this._visitables.get("validations");
        while (each.hasNext()) {
            V1ValidationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1Validation> buildValidations() {
        return this.validations != null ? V1ValidatingAdmissionPolicySpecFluent.build(this.validations) : null;
    }

    public V1Validation buildValidation(int index) {
        return this.validations.get(index).build();
    }

    public V1Validation buildFirstValidation() {
        return this.validations.get(0).build();
    }

    public V1Validation buildLastValidation() {
        return this.validations.get(this.validations.size() - 1).build();
    }

    public V1Validation buildMatchingValidation(Predicate<V1ValidationBuilder> predicate) {
        for (V1ValidationBuilder item : this.validations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingValidation(Predicate<V1ValidationBuilder> predicate) {
        for (V1ValidationBuilder item : this.validations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withValidations(List<V1Validation> validations) {
        if (this.validations != null) {
            this._visitables.get("validations").clear();
        }
        if (validations != null) {
            this.validations = new ArrayList();
            for (V1Validation item : validations) {
                this.addToValidations(item);
            }
        } else {
            this.validations = null;
        }
        return (A)this;
    }

    public A withValidations(V1Validation ... validations) {
        if (this.validations != null) {
            this.validations.clear();
            this._visitables.remove("validations");
        }
        if (validations != null) {
            for (V1Validation item : validations) {
                this.addToValidations(item);
            }
        }
        return (A)this;
    }

    public boolean hasValidations() {
        return this.validations != null && !this.validations.isEmpty();
    }

    public ValidationsNested<A> addNewValidation() {
        return new ValidationsNested(-1, null);
    }

    public ValidationsNested<A> addNewValidationLike(V1Validation item) {
        return new ValidationsNested(-1, item);
    }

    public ValidationsNested<A> setNewValidationLike(int index, V1Validation item) {
        return new ValidationsNested(index, item);
    }

    public ValidationsNested<A> editValidation(int index) {
        if (this.validations.size() <= index) {
            throw new RuntimeException("Can't edit validations. Index exceeds size.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    public ValidationsNested<A> editFirstValidation() {
        if (this.validations.size() == 0) {
            throw new RuntimeException("Can't edit first validations. The list is empty.");
        }
        return this.setNewValidationLike(0, this.buildValidation(0));
    }

    public ValidationsNested<A> editLastValidation() {
        int index = this.validations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last validations. The list is empty.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    public ValidationsNested<A> editMatchingValidation(Predicate<V1ValidationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.validations.size(); ++i) {
            if (!predicate.test(this.validations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching validations. No match found.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    public A addToVariables(int index, V1Variable item) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        V1VariableBuilder builder = new V1VariableBuilder(item);
        if (index < 0 || index >= this.variables.size()) {
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        } else {
            this._visitables.get("variables").add(index, builder);
            this.variables.add(index, builder);
        }
        return (A)this;
    }

    public A setToVariables(int index, V1Variable item) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        V1VariableBuilder builder = new V1VariableBuilder(item);
        if (index < 0 || index >= this.variables.size()) {
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        } else {
            this._visitables.get("variables").set(index, builder);
            this.variables.set(index, builder);
        }
        return (A)this;
    }

    public A addToVariables(V1Variable ... items) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        for (V1Variable item : items) {
            V1VariableBuilder builder = new V1VariableBuilder(item);
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        }
        return (A)this;
    }

    public A addAllToVariables(Collection<V1Variable> items) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        for (V1Variable item : items) {
            V1VariableBuilder builder = new V1VariableBuilder(item);
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        }
        return (A)this;
    }

    public A removeFromVariables(V1Variable ... items) {
        if (this.variables == null) {
            return (A)this;
        }
        for (V1Variable item : items) {
            V1VariableBuilder builder = new V1VariableBuilder(item);
            this._visitables.get("variables").remove(builder);
            this.variables.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVariables(Collection<V1Variable> items) {
        if (this.variables == null) {
            return (A)this;
        }
        for (V1Variable item : items) {
            V1VariableBuilder builder = new V1VariableBuilder(item);
            this._visitables.get("variables").remove(builder);
            this.variables.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVariables(Predicate<V1VariableBuilder> predicate) {
        if (this.variables == null) {
            return (A)this;
        }
        Iterator<V1VariableBuilder> each = this.variables.iterator();
        Object visitables = this._visitables.get("variables");
        while (each.hasNext()) {
            V1VariableBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1Variable> buildVariables() {
        return this.variables != null ? V1ValidatingAdmissionPolicySpecFluent.build(this.variables) : null;
    }

    public V1Variable buildVariable(int index) {
        return this.variables.get(index).build();
    }

    public V1Variable buildFirstVariable() {
        return this.variables.get(0).build();
    }

    public V1Variable buildLastVariable() {
        return this.variables.get(this.variables.size() - 1).build();
    }

    public V1Variable buildMatchingVariable(Predicate<V1VariableBuilder> predicate) {
        for (V1VariableBuilder item : this.variables) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVariable(Predicate<V1VariableBuilder> predicate) {
        for (V1VariableBuilder item : this.variables) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVariables(List<V1Variable> variables) {
        if (this.variables != null) {
            this._visitables.get("variables").clear();
        }
        if (variables != null) {
            this.variables = new ArrayList();
            for (V1Variable item : variables) {
                this.addToVariables(item);
            }
        } else {
            this.variables = null;
        }
        return (A)this;
    }

    public A withVariables(V1Variable ... variables) {
        if (this.variables != null) {
            this.variables.clear();
            this._visitables.remove("variables");
        }
        if (variables != null) {
            for (V1Variable item : variables) {
                this.addToVariables(item);
            }
        }
        return (A)this;
    }

    public boolean hasVariables() {
        return this.variables != null && !this.variables.isEmpty();
    }

    public VariablesNested<A> addNewVariable() {
        return new VariablesNested(-1, null);
    }

    public VariablesNested<A> addNewVariableLike(V1Variable item) {
        return new VariablesNested(-1, item);
    }

    public VariablesNested<A> setNewVariableLike(int index, V1Variable item) {
        return new VariablesNested(index, item);
    }

    public VariablesNested<A> editVariable(int index) {
        if (this.variables.size() <= index) {
            throw new RuntimeException("Can't edit variables. Index exceeds size.");
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    public VariablesNested<A> editFirstVariable() {
        if (this.variables.size() == 0) {
            throw new RuntimeException("Can't edit first variables. The list is empty.");
        }
        return this.setNewVariableLike(0, this.buildVariable(0));
    }

    public VariablesNested<A> editLastVariable() {
        int index = this.variables.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last variables. The list is empty.");
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    public VariablesNested<A> editMatchingVariable(Predicate<V1VariableBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.variables.size(); ++i) {
            if (!predicate.test(this.variables.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching variables. No match found.");
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ValidatingAdmissionPolicySpecFluent that = (V1ValidatingAdmissionPolicySpecFluent)o;
        if (!Objects.equals(this.auditAnnotations, that.auditAnnotations)) {
            return false;
        }
        if (!Objects.equals(this.failurePolicy, that.failurePolicy)) {
            return false;
        }
        if (!Objects.equals(this.matchConditions, that.matchConditions)) {
            return false;
        }
        if (!Objects.equals(this.matchConstraints, that.matchConstraints)) {
            return false;
        }
        if (!Objects.equals(this.paramKind, that.paramKind)) {
            return false;
        }
        if (!Objects.equals(this.validations, that.validations)) {
            return false;
        }
        return Objects.equals(this.variables, that.variables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.auditAnnotations, this.failurePolicy, this.matchConditions, this.matchConstraints, this.paramKind, this.validations, this.variables, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auditAnnotations != null && !this.auditAnnotations.isEmpty()) {
            sb.append("auditAnnotations:");
            sb.append(this.auditAnnotations + ",");
        }
        if (this.failurePolicy != null) {
            sb.append("failurePolicy:");
            sb.append(this.failurePolicy + ",");
        }
        if (this.matchConditions != null && !this.matchConditions.isEmpty()) {
            sb.append("matchConditions:");
            sb.append(this.matchConditions + ",");
        }
        if (this.matchConstraints != null) {
            sb.append("matchConstraints:");
            sb.append(this.matchConstraints + ",");
        }
        if (this.paramKind != null) {
            sb.append("paramKind:");
            sb.append(this.paramKind + ",");
        }
        if (this.validations != null && !this.validations.isEmpty()) {
            sb.append("validations:");
            sb.append(this.validations + ",");
        }
        if (this.variables != null && !this.variables.isEmpty()) {
            sb.append("variables:");
            sb.append(this.variables);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AuditAnnotationsNested<N>
    extends V1AuditAnnotationFluent<AuditAnnotationsNested<N>>
    implements Nested<N> {
        V1AuditAnnotationBuilder builder;
        int index;

        AuditAnnotationsNested(int index, V1AuditAnnotation item) {
            this.index = index;
            this.builder = new V1AuditAnnotationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ValidatingAdmissionPolicySpecFluent.this.setToAuditAnnotations(this.index, this.builder.build());
        }

        public N endAuditAnnotation() {
            return this.and();
        }
    }

    public class MatchConditionsNested<N>
    extends V1MatchConditionFluent<MatchConditionsNested<N>>
    implements Nested<N> {
        V1MatchConditionBuilder builder;
        int index;

        MatchConditionsNested(int index, V1MatchCondition item) {
            this.index = index;
            this.builder = new V1MatchConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ValidatingAdmissionPolicySpecFluent.this.setToMatchConditions(this.index, this.builder.build());
        }

        public N endMatchCondition() {
            return this.and();
        }
    }

    public class MatchConstraintsNested<N>
    extends V1MatchResourcesFluent<MatchConstraintsNested<N>>
    implements Nested<N> {
        V1MatchResourcesBuilder builder;

        MatchConstraintsNested(V1MatchResources item) {
            this.builder = new V1MatchResourcesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ValidatingAdmissionPolicySpecFluent.this.withMatchConstraints(this.builder.build());
        }

        public N endMatchConstraints() {
            return this.and();
        }
    }

    public class ParamKindNested<N>
    extends V1ParamKindFluent<ParamKindNested<N>>
    implements Nested<N> {
        V1ParamKindBuilder builder;

        ParamKindNested(V1ParamKind item) {
            this.builder = new V1ParamKindBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ValidatingAdmissionPolicySpecFluent.this.withParamKind(this.builder.build());
        }

        public N endParamKind() {
            return this.and();
        }
    }

    public class ValidationsNested<N>
    extends V1ValidationFluent<ValidationsNested<N>>
    implements Nested<N> {
        V1ValidationBuilder builder;
        int index;

        ValidationsNested(int index, V1Validation item) {
            this.index = index;
            this.builder = new V1ValidationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ValidatingAdmissionPolicySpecFluent.this.setToValidations(this.index, this.builder.build());
        }

        public N endValidation() {
            return this.and();
        }
    }

    public class VariablesNested<N>
    extends V1VariableFluent<VariablesNested<N>>
    implements Nested<N> {
        V1VariableBuilder builder;
        int index;

        VariablesNested(int index, V1Variable item) {
            this.index = index;
            this.builder = new V1VariableBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ValidatingAdmissionPolicySpecFluent.this.setToVariables(this.index, this.builder.build());
        }

        public N endVariable() {
            return this.and();
        }
    }
}

