/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1StatefulSetCondition;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1StatefulSetStatus {
    public static final String SERIALIZED_NAME_AVAILABLE_REPLICAS = "availableReplicas";
    @SerializedName(value="availableReplicas")
    private Integer availableReplicas;
    public static final String SERIALIZED_NAME_COLLISION_COUNT = "collisionCount";
    @SerializedName(value="collisionCount")
    private Integer collisionCount;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1StatefulSetCondition> conditions;
    public static final String SERIALIZED_NAME_CURRENT_REPLICAS = "currentReplicas";
    @SerializedName(value="currentReplicas")
    private Integer currentReplicas;
    public static final String SERIALIZED_NAME_CURRENT_REVISION = "currentRevision";
    @SerializedName(value="currentRevision")
    private String currentRevision;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    private Long observedGeneration;
    public static final String SERIALIZED_NAME_READY_REPLICAS = "readyReplicas";
    @SerializedName(value="readyReplicas")
    private Integer readyReplicas;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    private Integer replicas;
    public static final String SERIALIZED_NAME_UPDATE_REVISION = "updateRevision";
    @SerializedName(value="updateRevision")
    private String updateRevision;
    public static final String SERIALIZED_NAME_UPDATED_REPLICAS = "updatedReplicas";
    @SerializedName(value="updatedReplicas")
    private Integer updatedReplicas;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1StatefulSetStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @Nullable
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public V1StatefulSetStatus collisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @Nullable
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public V1StatefulSetStatus conditions(List<V1StatefulSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1StatefulSetStatus addConditionsItem(V1StatefulSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1StatefulSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    public List<V1StatefulSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1StatefulSetCondition> conditions) {
        this.conditions = conditions;
    }

    public V1StatefulSetStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    @Nullable
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public V1StatefulSetStatus currentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
        return this;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.currentRevision;
    }

    public void setCurrentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
    }

    public V1StatefulSetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1StatefulSetStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @Nullable
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public V1StatefulSetStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nonnull
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1StatefulSetStatus updateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
        return this;
    }

    @Nullable
    public String getUpdateRevision() {
        return this.updateRevision;
    }

    public void setUpdateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
    }

    public V1StatefulSetStatus updatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return this;
    }

    @Nullable
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public void setUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatefulSetStatus v1StatefulSetStatus = (V1StatefulSetStatus)o;
        return Objects.equals(this.availableReplicas, v1StatefulSetStatus.availableReplicas) && Objects.equals(this.collisionCount, v1StatefulSetStatus.collisionCount) && Objects.equals(this.conditions, v1StatefulSetStatus.conditions) && Objects.equals(this.currentReplicas, v1StatefulSetStatus.currentReplicas) && Objects.equals(this.currentRevision, v1StatefulSetStatus.currentRevision) && Objects.equals(this.observedGeneration, v1StatefulSetStatus.observedGeneration) && Objects.equals(this.readyReplicas, v1StatefulSetStatus.readyReplicas) && Objects.equals(this.replicas, v1StatefulSetStatus.replicas) && Objects.equals(this.updateRevision, v1StatefulSetStatus.updateRevision) && Objects.equals(this.updatedReplicas, v1StatefulSetStatus.updatedReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.collisionCount, this.conditions, this.currentReplicas, this.currentRevision, this.observedGeneration, this.readyReplicas, this.replicas, this.updateRevision, this.updatedReplicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StatefulSetStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentReplicas: ").append(this.toIndentedString(this.currentReplicas)).append("\n");
        sb.append("    currentRevision: ").append(this.toIndentedString(this.currentRevision)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    updateRevision: ").append(this.toIndentedString(this.updateRevision)).append("\n");
        sb.append("    updatedReplicas: ").append(this.toIndentedString(this.updatedReplicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayconditions;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1StatefulSetStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1StatefulSetStatus` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                V1StatefulSetCondition.validateJsonObject(jsonArrayconditions.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENT_REVISION) != null && !jsonObj.get(SERIALIZED_NAME_CURRENT_REVISION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENT_REVISION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currentRevision` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENT_REVISION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UPDATE_REVISION) != null && !jsonObj.get(SERIALIZED_NAME_UPDATE_REVISION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UPDATE_REVISION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `updateRevision` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UPDATE_REVISION).toString()));
        }
    }

    public static V1StatefulSetStatus fromJson(String jsonString) throws IOException {
        return (V1StatefulSetStatus)JSON.getGson().fromJson(jsonString, V1StatefulSetStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AVAILABLE_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_COLLISION_COUNT);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_CURRENT_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_CURRENT_REVISION);
        openapiFields.add(SERIALIZED_NAME_OBSERVED_GENERATION);
        openapiFields.add(SERIALIZED_NAME_READY_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_UPDATE_REVISION);
        openapiFields.add(SERIALIZED_NAME_UPDATED_REPLICAS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_REPLICAS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1StatefulSetStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1StatefulSetStatus.class));
            return new TypeAdapter<V1StatefulSetStatus>(){

                public void write(JsonWriter out, V1StatefulSetStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1StatefulSetStatus read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1StatefulSetStatus.validateJsonObject(jsonObj);
                    return (V1StatefulSetStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

