/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1LocalSubjectAccessReview;
import io.kubernetes.client.openapi.models.V1SelfSubjectAccessReview;
import io.kubernetes.client.openapi.models.V1SelfSubjectRulesReview;
import io.kubernetes.client.openapi.models.V1SubjectAccessReview;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AuthorizationV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AuthorizationV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createNamespacedLocalSubjectAccessReviewCall(String namespace, V1LocalSubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1LocalSubjectAccessReview localVarPostBody = body;
        String localVarPath = "/apis/authorization.k8s.io/v1/namespaces/{namespace}/localsubjectaccessreviews".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedLocalSubjectAccessReviewValidateBeforeCall(String namespace, V1LocalSubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedLocalSubjectAccessReview(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedLocalSubjectAccessReview(Async)");
        }
        return this.createNamespacedLocalSubjectAccessReviewCall(namespace, body, dryRun, fieldManager, fieldValidation, pretty, _callback);
    }

    private ApiResponse<V1LocalSubjectAccessReview> createNamespacedLocalSubjectAccessReviewWithHttpInfo(String namespace, V1LocalSubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty) throws ApiException {
        Call localVarCall = this.createNamespacedLocalSubjectAccessReviewValidateBeforeCall(namespace, body, dryRun, fieldManager, fieldValidation, pretty, null);
        Type localVarReturnType = new TypeToken<V1LocalSubjectAccessReview>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createNamespacedLocalSubjectAccessReviewAsync(String namespace, V1LocalSubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback<V1LocalSubjectAccessReview> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedLocalSubjectAccessReviewValidateBeforeCall(namespace, body, dryRun, fieldManager, fieldValidation, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1LocalSubjectAccessReview>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateNamespacedLocalSubjectAccessReviewRequest createNamespacedLocalSubjectAccessReview(String namespace, V1LocalSubjectAccessReview body) {
        return new APIcreateNamespacedLocalSubjectAccessReviewRequest(namespace, body);
    }

    private Call createSelfSubjectAccessReviewCall(V1SelfSubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1SelfSubjectAccessReview localVarPostBody = body;
        String localVarPath = "/apis/authorization.k8s.io/v1/selfsubjectaccessreviews";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSelfSubjectAccessReviewValidateBeforeCall(V1SelfSubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createSelfSubjectAccessReview(Async)");
        }
        return this.createSelfSubjectAccessReviewCall(body, dryRun, fieldManager, fieldValidation, pretty, _callback);
    }

    private ApiResponse<V1SelfSubjectAccessReview> createSelfSubjectAccessReviewWithHttpInfo(V1SelfSubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty) throws ApiException {
        Call localVarCall = this.createSelfSubjectAccessReviewValidateBeforeCall(body, dryRun, fieldManager, fieldValidation, pretty, null);
        Type localVarReturnType = new TypeToken<V1SelfSubjectAccessReview>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createSelfSubjectAccessReviewAsync(V1SelfSubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback<V1SelfSubjectAccessReview> _callback) throws ApiException {
        Call localVarCall = this.createSelfSubjectAccessReviewValidateBeforeCall(body, dryRun, fieldManager, fieldValidation, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1SelfSubjectAccessReview>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateSelfSubjectAccessReviewRequest createSelfSubjectAccessReview(V1SelfSubjectAccessReview body) {
        return new APIcreateSelfSubjectAccessReviewRequest(body);
    }

    private Call createSelfSubjectRulesReviewCall(V1SelfSubjectRulesReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1SelfSubjectRulesReview localVarPostBody = body;
        String localVarPath = "/apis/authorization.k8s.io/v1/selfsubjectrulesreviews";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSelfSubjectRulesReviewValidateBeforeCall(V1SelfSubjectRulesReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createSelfSubjectRulesReview(Async)");
        }
        return this.createSelfSubjectRulesReviewCall(body, dryRun, fieldManager, fieldValidation, pretty, _callback);
    }

    private ApiResponse<V1SelfSubjectRulesReview> createSelfSubjectRulesReviewWithHttpInfo(V1SelfSubjectRulesReview body, String dryRun, String fieldManager, String fieldValidation, String pretty) throws ApiException {
        Call localVarCall = this.createSelfSubjectRulesReviewValidateBeforeCall(body, dryRun, fieldManager, fieldValidation, pretty, null);
        Type localVarReturnType = new TypeToken<V1SelfSubjectRulesReview>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createSelfSubjectRulesReviewAsync(V1SelfSubjectRulesReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback<V1SelfSubjectRulesReview> _callback) throws ApiException {
        Call localVarCall = this.createSelfSubjectRulesReviewValidateBeforeCall(body, dryRun, fieldManager, fieldValidation, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1SelfSubjectRulesReview>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateSelfSubjectRulesReviewRequest createSelfSubjectRulesReview(V1SelfSubjectRulesReview body) {
        return new APIcreateSelfSubjectRulesReviewRequest(body);
    }

    private Call createSubjectAccessReviewCall(V1SubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1SubjectAccessReview localVarPostBody = body;
        String localVarPath = "/apis/authorization.k8s.io/v1/subjectaccessreviews";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSubjectAccessReviewValidateBeforeCall(V1SubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createSubjectAccessReview(Async)");
        }
        return this.createSubjectAccessReviewCall(body, dryRun, fieldManager, fieldValidation, pretty, _callback);
    }

    private ApiResponse<V1SubjectAccessReview> createSubjectAccessReviewWithHttpInfo(V1SubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty) throws ApiException {
        Call localVarCall = this.createSubjectAccessReviewValidateBeforeCall(body, dryRun, fieldManager, fieldValidation, pretty, null);
        Type localVarReturnType = new TypeToken<V1SubjectAccessReview>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createSubjectAccessReviewAsync(V1SubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty, ApiCallback<V1SubjectAccessReview> _callback) throws ApiException {
        Call localVarCall = this.createSubjectAccessReviewValidateBeforeCall(body, dryRun, fieldManager, fieldValidation, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1SubjectAccessReview>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateSubjectAccessReviewRequest createSubjectAccessReview(V1SubjectAccessReview body) {
        return new APIcreateSubjectAccessReviewRequest(body);
    }

    private Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/authorization.k8s.io/v1/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getAPIResourcesCall(_callback);
    }

    private ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetAPIResourcesRequest getAPIResources() {
        return new APIgetAPIResourcesRequest();
    }

    public class APIcreateNamespacedLocalSubjectAccessReviewRequest {
        private final String namespace;
        private final V1LocalSubjectAccessReview body;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private String pretty;

        private APIcreateNamespacedLocalSubjectAccessReviewRequest(String namespace, V1LocalSubjectAccessReview body) {
            this.namespace = namespace;
            this.body = body;
        }

        public APIcreateNamespacedLocalSubjectAccessReviewRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateNamespacedLocalSubjectAccessReviewRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateNamespacedLocalSubjectAccessReviewRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIcreateNamespacedLocalSubjectAccessReviewRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthorizationV1Api.this.createNamespacedLocalSubjectAccessReviewCall(this.namespace, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty, _callback);
        }

        public V1LocalSubjectAccessReview execute() throws ApiException {
            ApiResponse localVarResp = AuthorizationV1Api.this.createNamespacedLocalSubjectAccessReviewWithHttpInfo(this.namespace, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty);
            return (V1LocalSubjectAccessReview)localVarResp.getData();
        }

        public ApiResponse<V1LocalSubjectAccessReview> executeWithHttpInfo() throws ApiException {
            return AuthorizationV1Api.this.createNamespacedLocalSubjectAccessReviewWithHttpInfo(this.namespace, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1LocalSubjectAccessReview> _callback) throws ApiException {
            return AuthorizationV1Api.this.createNamespacedLocalSubjectAccessReviewAsync(this.namespace, this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty, _callback);
        }
    }

    public class APIcreateSelfSubjectAccessReviewRequest {
        private final V1SelfSubjectAccessReview body;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private String pretty;

        private APIcreateSelfSubjectAccessReviewRequest(V1SelfSubjectAccessReview body) {
            this.body = body;
        }

        public APIcreateSelfSubjectAccessReviewRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateSelfSubjectAccessReviewRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateSelfSubjectAccessReviewRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIcreateSelfSubjectAccessReviewRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthorizationV1Api.this.createSelfSubjectAccessReviewCall(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty, _callback);
        }

        public V1SelfSubjectAccessReview execute() throws ApiException {
            ApiResponse localVarResp = AuthorizationV1Api.this.createSelfSubjectAccessReviewWithHttpInfo(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty);
            return (V1SelfSubjectAccessReview)localVarResp.getData();
        }

        public ApiResponse<V1SelfSubjectAccessReview> executeWithHttpInfo() throws ApiException {
            return AuthorizationV1Api.this.createSelfSubjectAccessReviewWithHttpInfo(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1SelfSubjectAccessReview> _callback) throws ApiException {
            return AuthorizationV1Api.this.createSelfSubjectAccessReviewAsync(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty, _callback);
        }
    }

    public class APIcreateSelfSubjectRulesReviewRequest {
        private final V1SelfSubjectRulesReview body;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private String pretty;

        private APIcreateSelfSubjectRulesReviewRequest(V1SelfSubjectRulesReview body) {
            this.body = body;
        }

        public APIcreateSelfSubjectRulesReviewRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateSelfSubjectRulesReviewRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateSelfSubjectRulesReviewRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIcreateSelfSubjectRulesReviewRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthorizationV1Api.this.createSelfSubjectRulesReviewCall(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty, _callback);
        }

        public V1SelfSubjectRulesReview execute() throws ApiException {
            ApiResponse localVarResp = AuthorizationV1Api.this.createSelfSubjectRulesReviewWithHttpInfo(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty);
            return (V1SelfSubjectRulesReview)localVarResp.getData();
        }

        public ApiResponse<V1SelfSubjectRulesReview> executeWithHttpInfo() throws ApiException {
            return AuthorizationV1Api.this.createSelfSubjectRulesReviewWithHttpInfo(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1SelfSubjectRulesReview> _callback) throws ApiException {
            return AuthorizationV1Api.this.createSelfSubjectRulesReviewAsync(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty, _callback);
        }
    }

    public class APIcreateSubjectAccessReviewRequest {
        private final V1SubjectAccessReview body;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private String pretty;

        private APIcreateSubjectAccessReviewRequest(V1SubjectAccessReview body) {
            this.body = body;
        }

        public APIcreateSubjectAccessReviewRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateSubjectAccessReviewRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateSubjectAccessReviewRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIcreateSubjectAccessReviewRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthorizationV1Api.this.createSubjectAccessReviewCall(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty, _callback);
        }

        public V1SubjectAccessReview execute() throws ApiException {
            ApiResponse localVarResp = AuthorizationV1Api.this.createSubjectAccessReviewWithHttpInfo(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty);
            return (V1SubjectAccessReview)localVarResp.getData();
        }

        public ApiResponse<V1SubjectAccessReview> executeWithHttpInfo() throws ApiException {
            return AuthorizationV1Api.this.createSubjectAccessReviewWithHttpInfo(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1SubjectAccessReview> _callback) throws ApiException {
            return AuthorizationV1Api.this.createSubjectAccessReviewAsync(this.body, this.dryRun, this.fieldManager, this.fieldValidation, this.pretty, _callback);
        }
    }

    public class APIgetAPIResourcesRequest {
        private APIgetAPIResourcesRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthorizationV1Api.this.getAPIResourcesCall(_callback);
        }

        public V1APIResourceList execute() throws ApiException {
            ApiResponse localVarResp = AuthorizationV1Api.this.getAPIResourcesWithHttpInfo();
            return (V1APIResourceList)localVarResp.getData();
        }

        public ApiResponse<V1APIResourceList> executeWithHttpInfo() throws ApiException {
            return AuthorizationV1Api.this.getAPIResourcesWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
            return AuthorizationV1Api.this.getAPIResourcesAsync(_callback);
        }
    }
}

