/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReference;
import io.kubernetes.client.openapi.models.V1alpha2ResourceFilter;
import io.kubernetes.client.openapi.models.V1alpha2VendorParameters;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceClassParameters defines resource requests for a ResourceClass in an in-tree format understood by Kubernetes.")
public class V1alpha2ResourceClassParameters
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_FILTERS = "filters";
    @SerializedName(value="filters")
    private List<V1alpha2ResourceFilter> filters = null;
    public static final String SERIALIZED_NAME_GENERATED_FROM = "generatedFrom";
    @SerializedName(value="generatedFrom")
    private V1alpha2ResourceClassParametersReference generatedFrom;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_VENDOR_PARAMETERS = "vendorParameters";
    @SerializedName(value="vendorParameters")
    private List<V1alpha2VendorParameters> vendorParameters = null;

    public V1alpha2ResourceClassParameters apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha2ResourceClassParameters filters(List<V1alpha2ResourceFilter> filters) {
        this.filters = filters;
        return this;
    }

    public V1alpha2ResourceClassParameters addFiltersItem(V1alpha2ResourceFilter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<V1alpha2ResourceFilter>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filters describes additional contraints that must be met when using the class.")
    public List<V1alpha2ResourceFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<V1alpha2ResourceFilter> filters) {
        this.filters = filters;
    }

    public V1alpha2ResourceClassParameters generatedFrom(V1alpha2ResourceClassParametersReference generatedFrom) {
        this.generatedFrom = generatedFrom;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha2ResourceClassParametersReference getGeneratedFrom() {
        return this.generatedFrom;
    }

    public void setGeneratedFrom(V1alpha2ResourceClassParametersReference generatedFrom) {
        this.generatedFrom = generatedFrom;
    }

    public V1alpha2ResourceClassParameters kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha2ResourceClassParameters metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha2ResourceClassParameters vendorParameters(List<V1alpha2VendorParameters> vendorParameters) {
        this.vendorParameters = vendorParameters;
        return this;
    }

    public V1alpha2ResourceClassParameters addVendorParametersItem(V1alpha2VendorParameters vendorParametersItem) {
        if (this.vendorParameters == null) {
            this.vendorParameters = new ArrayList<V1alpha2VendorParameters>();
        }
        this.vendorParameters.add(vendorParametersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VendorParameters are arbitrary setup parameters for all claims using this class. They are ignored while allocating the claim. There must not be more than one entry per driver.")
    public List<V1alpha2VendorParameters> getVendorParameters() {
        return this.vendorParameters;
    }

    public void setVendorParameters(List<V1alpha2VendorParameters> vendorParameters) {
        this.vendorParameters = vendorParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceClassParameters v1alpha2ResourceClassParameters = (V1alpha2ResourceClassParameters)o;
        return Objects.equals(this.apiVersion, v1alpha2ResourceClassParameters.apiVersion) && Objects.equals(this.filters, v1alpha2ResourceClassParameters.filters) && Objects.equals(this.generatedFrom, v1alpha2ResourceClassParameters.generatedFrom) && Objects.equals(this.kind, v1alpha2ResourceClassParameters.kind) && Objects.equals(this.metadata, v1alpha2ResourceClassParameters.metadata) && Objects.equals(this.vendorParameters, v1alpha2ResourceClassParameters.vendorParameters);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.filters, this.generatedFrom, this.kind, this.metadata, this.vendorParameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceClassParameters {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    generatedFrom: ").append(this.toIndentedString(this.generatedFrom)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    vendorParameters: ").append(this.toIndentedString(this.vendorParameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

