/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.ApiregistrationV1ServiceReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="APIServiceSpec contains information for locating and communicating with a server. Only https is supported, though you are able to disable certificate verification.")
public class V1APIServiceSpec {
    public static final String SERIALIZED_NAME_CA_BUNDLE = "caBundle";
    @SerializedName(value="caBundle")
    private byte[] caBundle;
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group;
    public static final String SERIALIZED_NAME_GROUP_PRIORITY_MINIMUM = "groupPriorityMinimum";
    @SerializedName(value="groupPriorityMinimum")
    private Integer groupPriorityMinimum;
    public static final String SERIALIZED_NAME_INSECURE_SKIP_T_L_S_VERIFY = "insecureSkipTLSVerify";
    @SerializedName(value="insecureSkipTLSVerify")
    private Boolean insecureSkipTLSVerify;
    public static final String SERIALIZED_NAME_SERVICE = "service";
    @SerializedName(value="service")
    private ApiregistrationV1ServiceReference service;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_VERSION_PRIORITY = "versionPriority";
    @SerializedName(value="versionPriority")
    private Integer versionPriority;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1APIServiceSpec caBundle(byte[] caBundle) {
        this.caBundle = caBundle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate. If unspecified, system trust roots on the apiserver are used.")
    public byte[] getCaBundle() {
        return this.caBundle;
    }

    public void setCaBundle(byte[] caBundle) {
        this.caBundle = caBundle;
    }

    public V1APIServiceSpec group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Group is the API group name this server hosts")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public V1APIServiceSpec groupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum = groupPriorityMinimum;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="GroupPriorityMinimum is the priority this group should have at least. Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMinimum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s")
    public Integer getGroupPriorityMinimum() {
        return this.groupPriorityMinimum;
    }

    public void setGroupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum = groupPriorityMinimum;
    }

    public V1APIServiceSpec insecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server. This is strongly discouraged.  You should use the CABundle instead.")
    public Boolean getInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    public void setInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
    }

    public V1APIServiceSpec service(ApiregistrationV1ServiceReference service) {
        this.service = service;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ApiregistrationV1ServiceReference getService() {
        return this.service;
    }

    public void setService(ApiregistrationV1ServiceReference service) {
        this.service = service;
    }

    public V1APIServiceSpec version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Version is the API version this server hosts.  For example, \"v1\"")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public V1APIServiceSpec versionPriority(Integer versionPriority) {
        this.versionPriority = versionPriority;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="VersionPriority controls the ordering of this API version inside of its group.  Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is \"kube-like\", it will sort above non \"kube-like\" version strings, which are ordered lexicographically. \"Kube-like\" versions start with a \"v\", then are followed by a number (the major version), then optionally the string \"alpha\" or \"beta\" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.")
    public Integer getVersionPriority() {
        return this.versionPriority;
    }

    public void setVersionPriority(Integer versionPriority) {
        this.versionPriority = versionPriority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIServiceSpec v1APIServiceSpec = (V1APIServiceSpec)o;
        return Arrays.equals(this.caBundle, v1APIServiceSpec.caBundle) && Objects.equals(this.group, v1APIServiceSpec.group) && Objects.equals(this.groupPriorityMinimum, v1APIServiceSpec.groupPriorityMinimum) && Objects.equals(this.insecureSkipTLSVerify, v1APIServiceSpec.insecureSkipTLSVerify) && Objects.equals(this.service, v1APIServiceSpec.service) && Objects.equals(this.version, v1APIServiceSpec.version) && Objects.equals(this.versionPriority, v1APIServiceSpec.versionPriority);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.caBundle), this.group, this.groupPriorityMinimum, this.insecureSkipTLSVerify, this.service, this.version, this.versionPriority);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1APIServiceSpec {\n");
        sb.append("    caBundle: ").append(this.toIndentedString(this.caBundle)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    groupPriorityMinimum: ").append(this.toIndentedString(this.groupPriorityMinimum)).append("\n");
        sb.append("    insecureSkipTLSVerify: ").append(this.toIndentedString(this.insecureSkipTLSVerify)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    versionPriority: ").append(this.toIndentedString(this.versionPriority)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1APIServiceSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1APIServiceSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_GROUP) != null && !jsonObj.get(SERIALIZED_NAME_GROUP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `group` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE) != null && !jsonObj.get(SERIALIZED_NAME_SERVICE).isJsonNull()) {
            ApiregistrationV1ServiceReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SERVICE));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
    }

    public static V1APIServiceSpec fromJson(String jsonString) throws IOException {
        return (V1APIServiceSpec)JSON.getGson().fromJson(jsonString, V1APIServiceSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CA_BUNDLE);
        openapiFields.add(SERIALIZED_NAME_GROUP);
        openapiFields.add(SERIALIZED_NAME_GROUP_PRIORITY_MINIMUM);
        openapiFields.add(SERIALIZED_NAME_INSECURE_SKIP_T_L_S_VERIFY);
        openapiFields.add(SERIALIZED_NAME_SERVICE);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_VERSION_PRIORITY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_GROUP_PRIORITY_MINIMUM);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION_PRIORITY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1APIServiceSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1APIServiceSpec.class));
            return new TypeAdapter<V1APIServiceSpec>(){

                public void write(JsonWriter out, V1APIServiceSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1APIServiceSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1APIServiceSpec.validateJsonElement(jsonElement);
                    return (V1APIServiceSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

