/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ExemptPriorityLevelConfiguration describes the configurable aspects of the handling of exempt requests. In the mandatory exempt configuration object the values in the fields here can be modified by authorized users, unlike the rest of the `spec`.")
public class V1ExemptPriorityLevelConfiguration {
    public static final String SERIALIZED_NAME_LENDABLE_PERCENT = "lendablePercent";
    @SerializedName(value="lendablePercent")
    private Integer lendablePercent;
    public static final String SERIALIZED_NAME_NOMINAL_CONCURRENCY_SHARES = "nominalConcurrencyShares";
    @SerializedName(value="nominalConcurrencyShares")
    private Integer nominalConcurrencyShares;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ExemptPriorityLevelConfiguration lendablePercent(Integer lendablePercent) {
        this.lendablePercent = lendablePercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.  This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.  LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )")
    public Integer getLendablePercent() {
        return this.lendablePercent;
    }

    public void setLendablePercent(Integer lendablePercent) {
        this.lendablePercent = lendablePercent;
    }

    public V1ExemptPriorityLevelConfiguration nominalConcurrencyShares(Integer nominalConcurrencyShares) {
        this.nominalConcurrencyShares = nominalConcurrencyShares;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:  NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)  Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.")
    public Integer getNominalConcurrencyShares() {
        return this.nominalConcurrencyShares;
    }

    public void setNominalConcurrencyShares(Integer nominalConcurrencyShares) {
        this.nominalConcurrencyShares = nominalConcurrencyShares;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ExemptPriorityLevelConfiguration v1ExemptPriorityLevelConfiguration = (V1ExemptPriorityLevelConfiguration)o;
        return Objects.equals(this.lendablePercent, v1ExemptPriorityLevelConfiguration.lendablePercent) && Objects.equals(this.nominalConcurrencyShares, v1ExemptPriorityLevelConfiguration.nominalConcurrencyShares);
    }

    public int hashCode() {
        return Objects.hash(this.lendablePercent, this.nominalConcurrencyShares);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ExemptPriorityLevelConfiguration {\n");
        sb.append("    lendablePercent: ").append(this.toIndentedString(this.lendablePercent)).append("\n");
        sb.append("    nominalConcurrencyShares: ").append(this.toIndentedString(this.nominalConcurrencyShares)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ExemptPriorityLevelConfiguration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ExemptPriorityLevelConfiguration` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
    }

    public static V1ExemptPriorityLevelConfiguration fromJson(String jsonString) throws IOException {
        return (V1ExemptPriorityLevelConfiguration)JSON.getGson().fromJson(jsonString, V1ExemptPriorityLevelConfiguration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LENDABLE_PERCENT);
        openapiFields.add(SERIALIZED_NAME_NOMINAL_CONCURRENCY_SHARES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ExemptPriorityLevelConfiguration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ExemptPriorityLevelConfiguration.class));
            return new TypeAdapter<V1ExemptPriorityLevelConfiguration>(){

                public void write(JsonWriter out, V1ExemptPriorityLevelConfiguration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ExemptPriorityLevelConfiguration read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ExemptPriorityLevelConfiguration.validateJsonElement(jsonElement);
                    return (V1ExemptPriorityLevelConfiguration)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

