/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.")
public class V1FCVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_LUN = "lun";
    @SerializedName(value="lun")
    private Integer lun;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_TARGET_W_W_NS = "targetWWNs";
    @SerializedName(value="targetWWNs")
    private List<String> targetWWNs = new ArrayList<String>();
    public static final String SERIALIZED_NAME_WWIDS = "wwids";
    @SerializedName(value="wwids")
    private List<String> wwids = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1FCVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1FCVolumeSource lun(Integer lun) {
        this.lun = lun;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="lun is Optional: FC target lun number")
    public Integer getLun() {
        return this.lun;
    }

    public void setLun(Integer lun) {
        this.lun = lun;
    }

    public V1FCVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1FCVolumeSource targetWWNs(List<String> targetWWNs) {
        this.targetWWNs = targetWWNs;
        return this;
    }

    public V1FCVolumeSource addTargetWWNsItem(String targetWWNsItem) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        this.targetWWNs.add(targetWWNsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="targetWWNs is Optional: FC target worldwide names (WWNs)")
    public List<String> getTargetWWNs() {
        return this.targetWWNs;
    }

    public void setTargetWWNs(List<String> targetWWNs) {
        this.targetWWNs = targetWWNs;
    }

    public V1FCVolumeSource wwids(List<String> wwids) {
        this.wwids = wwids;
        return this;
    }

    public V1FCVolumeSource addWwidsItem(String wwidsItem) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        this.wwids.add(wwidsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.")
    public List<String> getWwids() {
        return this.wwids;
    }

    public void setWwids(List<String> wwids) {
        this.wwids = wwids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1FCVolumeSource v1FCVolumeSource = (V1FCVolumeSource)o;
        return Objects.equals(this.fsType, v1FCVolumeSource.fsType) && Objects.equals(this.lun, v1FCVolumeSource.lun) && Objects.equals(this.readOnly, v1FCVolumeSource.readOnly) && Objects.equals(this.targetWWNs, v1FCVolumeSource.targetWWNs) && Objects.equals(this.wwids, v1FCVolumeSource.wwids);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.lun, this.readOnly, this.targetWWNs, this.wwids);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1FCVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    lun: ").append(this.toIndentedString(this.lun)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    targetWWNs: ").append(this.toIndentedString(this.targetWWNs)).append("\n");
        sb.append("    wwids: ").append(this.toIndentedString(this.wwids)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1FCVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1FCVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_FS_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fsType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FS_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_W_W_NS) != null && !jsonObj.get(SERIALIZED_NAME_TARGET_W_W_NS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TARGET_W_W_NS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `targetWWNs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_W_W_NS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WWIDS) != null && !jsonObj.get(SERIALIZED_NAME_WWIDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_WWIDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `wwids` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WWIDS).toString()));
        }
    }

    public static V1FCVolumeSource fromJson(String jsonString) throws IOException {
        return (V1FCVolumeSource)JSON.getGson().fromJson(jsonString, V1FCVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FS_TYPE);
        openapiFields.add(SERIALIZED_NAME_LUN);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_TARGET_W_W_NS);
        openapiFields.add(SERIALIZED_NAME_WWIDS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1FCVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1FCVolumeSource.class));
            return new TypeAdapter<V1FCVolumeSource>(){

                public void write(JsonWriter out, V1FCVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1FCVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1FCVolumeSource.validateJsonElement(jsonElement);
                    return (V1FCVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

