/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="current status of a horizontal pod autoscaler")
public class V1HorizontalPodAutoscalerStatus {
    public static final String SERIALIZED_NAME_CURRENT_C_P_U_UTILIZATION_PERCENTAGE = "currentCPUUtilizationPercentage";
    @SerializedName(value="currentCPUUtilizationPercentage")
    private Integer currentCPUUtilizationPercentage;
    public static final String SERIALIZED_NAME_CURRENT_REPLICAS = "currentReplicas";
    @SerializedName(value="currentReplicas")
    private Integer currentReplicas;
    public static final String SERIALIZED_NAME_DESIRED_REPLICAS = "desiredReplicas";
    @SerializedName(value="desiredReplicas")
    private Integer desiredReplicas;
    public static final String SERIALIZED_NAME_LAST_SCALE_TIME = "lastScaleTime";
    @SerializedName(value="lastScaleTime")
    private OffsetDateTime lastScaleTime;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    private Long observedGeneration;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1HorizontalPodAutoscalerStatus currentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
        this.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentCPUUtilizationPercentage is the current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.")
    public Integer getCurrentCPUUtilizationPercentage() {
        return this.currentCPUUtilizationPercentage;
    }

    public void setCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
        this.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
    }

    public V1HorizontalPodAutoscalerStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="currentReplicas is the current number of replicas of pods managed by this autoscaler.")
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public V1HorizontalPodAutoscalerStatus desiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="desiredReplicas is the  desired number of replicas of pods managed by this autoscaler.")
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public void setDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
    }

    public V1HorizontalPodAutoscalerStatus lastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed.")
    public OffsetDateTime getLastScaleTime() {
        return this.lastScaleTime;
    }

    public void setLastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
    }

    public V1HorizontalPodAutoscalerStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="observedGeneration is the most recent generation observed by this autoscaler.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HorizontalPodAutoscalerStatus v1HorizontalPodAutoscalerStatus = (V1HorizontalPodAutoscalerStatus)o;
        return Objects.equals(this.currentCPUUtilizationPercentage, v1HorizontalPodAutoscalerStatus.currentCPUUtilizationPercentage) && Objects.equals(this.currentReplicas, v1HorizontalPodAutoscalerStatus.currentReplicas) && Objects.equals(this.desiredReplicas, v1HorizontalPodAutoscalerStatus.desiredReplicas) && Objects.equals(this.lastScaleTime, v1HorizontalPodAutoscalerStatus.lastScaleTime) && Objects.equals(this.observedGeneration, v1HorizontalPodAutoscalerStatus.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.currentCPUUtilizationPercentage, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1HorizontalPodAutoscalerStatus {\n");
        sb.append("    currentCPUUtilizationPercentage: ").append(this.toIndentedString(this.currentCPUUtilizationPercentage)).append("\n");
        sb.append("    currentReplicas: ").append(this.toIndentedString(this.currentReplicas)).append("\n");
        sb.append("    desiredReplicas: ").append(this.toIndentedString(this.desiredReplicas)).append("\n");
        sb.append("    lastScaleTime: ").append(this.toIndentedString(this.lastScaleTime)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1HorizontalPodAutoscalerStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1HorizontalPodAutoscalerStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
    }

    public static V1HorizontalPodAutoscalerStatus fromJson(String jsonString) throws IOException {
        return (V1HorizontalPodAutoscalerStatus)JSON.getGson().fromJson(jsonString, V1HorizontalPodAutoscalerStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CURRENT_C_P_U_UTILIZATION_PERCENTAGE);
        openapiFields.add(SERIALIZED_NAME_CURRENT_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_DESIRED_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_LAST_SCALE_TIME);
        openapiFields.add(SERIALIZED_NAME_OBSERVED_GENERATION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENT_REPLICAS);
        openapiRequiredFields.add(SERIALIZED_NAME_DESIRED_REPLICAS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1HorizontalPodAutoscalerStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1HorizontalPodAutoscalerStatus.class));
            return new TypeAdapter<V1HorizontalPodAutoscalerStatus>(){

                public void write(JsonWriter out, V1HorizontalPodAutoscalerStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1HorizontalPodAutoscalerStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1HorizontalPodAutoscalerStatus.validateJsonElement(jsonElement);
                    return (V1HorizontalPodAutoscalerStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

