/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="IngressTLS describes the transport layer security associated with an ingress.")
public class V1IngressTLS {
    public static final String SERIALIZED_NAME_HOSTS = "hosts";
    @SerializedName(value="hosts")
    private List<String> hosts = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SECRET_NAME = "secretName";
    @SerializedName(value="secretName")
    private String secretName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1IngressTLS hosts(List<String> hosts) {
        this.hosts = hosts;
        return this;
    }

    public V1IngressTLS addHostsItem(String hostsItem) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(hostsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.")
    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public V1IngressTLS secretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the \"Host\" header field used by an IngressRule, the SNI host is used for termination and value of the \"Host\" header is used for routing.")
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IngressTLS v1IngressTLS = (V1IngressTLS)o;
        return Objects.equals(this.hosts, v1IngressTLS.hosts) && Objects.equals(this.secretName, v1IngressTLS.secretName);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.secretName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1IngressTLS {\n");
        sb.append("    hosts: ").append(this.toIndentedString(this.hosts)).append("\n");
        sb.append("    secretName: ").append(this.toIndentedString(this.secretName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1IngressTLS is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1IngressTLS` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_HOSTS) != null && !jsonObj.get(SERIALIZED_NAME_HOSTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `hosts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRET_NAME) != null && !jsonObj.get(SERIALIZED_NAME_SECRET_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECRET_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `secretName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRET_NAME).toString()));
        }
    }

    public static V1IngressTLS fromJson(String jsonString) throws IOException {
        return (V1IngressTLS)JSON.getGson().fromJson(jsonString, V1IngressTLS.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HOSTS);
        openapiFields.add(SERIALIZED_NAME_SECRET_NAME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1IngressTLS.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1IngressTLS.class));
            return new TypeAdapter<V1IngressTLS>(){

                public void write(JsonWriter out, V1IngressTLS value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1IngressTLS read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1IngressTLS.validateJsonElement(jsonElement);
                    return (V1IngressTLS)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

