/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1PodFailurePolicy;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1SuccessPolicy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="JobSpec describes how the job execution will look like.")
public class V1JobSpec {
    public static final String SERIALIZED_NAME_ACTIVE_DEADLINE_SECONDS = "activeDeadlineSeconds";
    @SerializedName(value="activeDeadlineSeconds")
    private Long activeDeadlineSeconds;
    public static final String SERIALIZED_NAME_BACKOFF_LIMIT = "backoffLimit";
    @SerializedName(value="backoffLimit")
    private Integer backoffLimit;
    public static final String SERIALIZED_NAME_BACKOFF_LIMIT_PER_INDEX = "backoffLimitPerIndex";
    @SerializedName(value="backoffLimitPerIndex")
    private Integer backoffLimitPerIndex;
    public static final String SERIALIZED_NAME_COMPLETION_MODE = "completionMode";
    @SerializedName(value="completionMode")
    private String completionMode;
    public static final String SERIALIZED_NAME_COMPLETIONS = "completions";
    @SerializedName(value="completions")
    private Integer completions;
    public static final String SERIALIZED_NAME_MANAGED_BY = "managedBy";
    @SerializedName(value="managedBy")
    private String managedBy;
    public static final String SERIALIZED_NAME_MANUAL_SELECTOR = "manualSelector";
    @SerializedName(value="manualSelector")
    private Boolean manualSelector;
    public static final String SERIALIZED_NAME_MAX_FAILED_INDEXES = "maxFailedIndexes";
    @SerializedName(value="maxFailedIndexes")
    private Integer maxFailedIndexes;
    public static final String SERIALIZED_NAME_PARALLELISM = "parallelism";
    @SerializedName(value="parallelism")
    private Integer parallelism;
    public static final String SERIALIZED_NAME_POD_FAILURE_POLICY = "podFailurePolicy";
    @SerializedName(value="podFailurePolicy")
    private V1PodFailurePolicy podFailurePolicy;
    public static final String SERIALIZED_NAME_POD_REPLACEMENT_POLICY = "podReplacementPolicy";
    @SerializedName(value="podReplacementPolicy")
    private String podReplacementPolicy;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1LabelSelector selector;
    public static final String SERIALIZED_NAME_SUCCESS_POLICY = "successPolicy";
    @SerializedName(value="successPolicy")
    private V1SuccessPolicy successPolicy;
    public static final String SERIALIZED_NAME_SUSPEND = "suspend";
    @SerializedName(value="suspend")
    private Boolean suspend;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private V1PodTemplateSpec template;
    public static final String SERIALIZED_NAME_TTL_SECONDS_AFTER_FINISHED = "ttlSecondsAfterFinished";
    @SerializedName(value="ttlSecondsAfterFinished")
    private Integer ttlSecondsAfterFinished;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1JobSpec activeDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.")
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public void setActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    public V1JobSpec backoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the number of retries before marking this job failed. Defaults to 6")
    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    public void setBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
    }

    public V1JobSpec backoffLimitPerIndex(Integer backoffLimitPerIndex) {
        this.backoffLimitPerIndex = backoffLimitPerIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the limit for the number of retries within an index before marking this index as failed. When enabled the number of failures per index is kept in the pod's batch.kubernetes.io/job-index-failure-count annotation. It can only be set when Job's completionMode=Indexed, and the Pod's restart policy is Never. The field is immutable. This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).")
    public Integer getBackoffLimitPerIndex() {
        return this.backoffLimitPerIndex;
    }

    public void setBackoffLimitPerIndex(Integer backoffLimitPerIndex) {
        this.backoffLimitPerIndex = backoffLimitPerIndex;
    }

    public V1JobSpec completionMode(String completionMode) {
        this.completionMode = completionMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="completionMode specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`.  `NonIndexed` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.  `Indexed` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be less than or equal to 10^5. In addition, The Pod name takes the form `$(job-name)-$(index)-$(random-string)`, the Pod hostname takes the form `$(job-name)-$(index)`.  More completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.")
    public String getCompletionMode() {
        return this.completionMode;
    }

    public void setCompletionMode(String completionMode) {
        this.completionMode = completionMode;
    }

    public V1JobSpec completions(Integer completions) {
        this.completions = completions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the desired number of successfully finished pods the job should be run with.  Setting to null means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    public Integer getCompletions() {
        return this.completions;
    }

    public void setCompletions(Integer completions) {
        this.completions = completions;
    }

    public V1JobSpec managedBy(String managedBy) {
        this.managedBy = managedBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ManagedBy field indicates the controller that manages a Job. The k8s Job controller reconciles jobs which don't have this field at all or the field value is the reserved string `kubernetes.io/job-controller`, but skips reconciling Jobs with a custom value for this field. The value must be a valid domain-prefixed path (e.g. acme.io/foo) - all characters before the first \"/\" must be a valid subdomain as defined by RFC 1123. All characters trailing the first \"/\" must be valid HTTP Path characters as defined by RFC 3986. The value cannot exceed 63 characters. This field is immutable.  This field is beta-level. The job controller accepts setting the field when the feature gate JobManagedBy is enabled (enabled by default).")
    public String getManagedBy() {
        return this.managedBy;
    }

    public void setManagedBy(String managedBy) {
        this.managedBy = managedBy;
    }

    public V1JobSpec manualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector")
    public Boolean getManualSelector() {
        return this.manualSelector;
    }

    public void setManualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
    }

    public V1JobSpec maxFailedIndexes(Integer maxFailedIndexes) {
        this.maxFailedIndexes = maxFailedIndexes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the maximal number of failed indexes before marking the Job as failed, when backoffLimitPerIndex is set. Once the number of failed indexes exceeds this number the entire Job is marked as Failed and its execution is terminated. When left as null the job continues execution of all of its indexes and is marked with the `Complete` Job condition. It can only be specified when backoffLimitPerIndex is set. It can be null or up to completions. It is required and must be less than or equal to 10^4 when is completions greater than 10^5. This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).")
    public Integer getMaxFailedIndexes() {
        return this.maxFailedIndexes;
    }

    public void setMaxFailedIndexes(Integer maxFailedIndexes) {
        this.maxFailedIndexes = maxFailedIndexes;
    }

    public V1JobSpec parallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    public Integer getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public V1JobSpec podFailurePolicy(V1PodFailurePolicy podFailurePolicy) {
        this.podFailurePolicy = podFailurePolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PodFailurePolicy getPodFailurePolicy() {
        return this.podFailurePolicy;
    }

    public void setPodFailurePolicy(V1PodFailurePolicy podFailurePolicy) {
        this.podFailurePolicy = podFailurePolicy;
    }

    public V1JobSpec podReplacementPolicy(String podReplacementPolicy) {
        this.podReplacementPolicy = podReplacementPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="podReplacementPolicy specifies when to create replacement Pods. Possible values are: - TerminatingOrFailed means that we recreate pods   when they are terminating (has a metadata.deletionTimestamp) or failed. - Failed means to wait until a previously created Pod is fully terminated (has phase   Failed or Succeeded) before creating a replacement Pod.  When using podFailurePolicy, Failed is the the only allowed value. TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use. This is an beta field. To use this, enable the JobPodReplacementPolicy feature toggle. This is on by default.")
    public String getPodReplacementPolicy() {
        return this.podReplacementPolicy;
    }

    public void setPodReplacementPolicy(String podReplacementPolicy) {
        this.podReplacementPolicy = podReplacementPolicy;
    }

    public V1JobSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1JobSpec successPolicy(V1SuccessPolicy successPolicy) {
        this.successPolicy = successPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SuccessPolicy getSuccessPolicy() {
        return this.successPolicy;
    }

    public void setSuccessPolicy(V1SuccessPolicy successPolicy) {
        this.successPolicy = successPolicy;
    }

    public V1JobSpec suspend(Boolean suspend) {
        this.suspend = suspend;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false.")
    public Boolean getSuspend() {
        return this.suspend;
    }

    public void setSuspend(Boolean suspend) {
        this.suspend = suspend;
    }

    public V1JobSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1JobSpec ttlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.")
    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    public void setTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1JobSpec v1JobSpec = (V1JobSpec)o;
        return Objects.equals(this.activeDeadlineSeconds, v1JobSpec.activeDeadlineSeconds) && Objects.equals(this.backoffLimit, v1JobSpec.backoffLimit) && Objects.equals(this.backoffLimitPerIndex, v1JobSpec.backoffLimitPerIndex) && Objects.equals(this.completionMode, v1JobSpec.completionMode) && Objects.equals(this.completions, v1JobSpec.completions) && Objects.equals(this.managedBy, v1JobSpec.managedBy) && Objects.equals(this.manualSelector, v1JobSpec.manualSelector) && Objects.equals(this.maxFailedIndexes, v1JobSpec.maxFailedIndexes) && Objects.equals(this.parallelism, v1JobSpec.parallelism) && Objects.equals(this.podFailurePolicy, v1JobSpec.podFailurePolicy) && Objects.equals(this.podReplacementPolicy, v1JobSpec.podReplacementPolicy) && Objects.equals(this.selector, v1JobSpec.selector) && Objects.equals(this.successPolicy, v1JobSpec.successPolicy) && Objects.equals(this.suspend, v1JobSpec.suspend) && Objects.equals(this.template, v1JobSpec.template) && Objects.equals(this.ttlSecondsAfterFinished, v1JobSpec.ttlSecondsAfterFinished);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.backoffLimit, this.backoffLimitPerIndex, this.completionMode, this.completions, this.managedBy, this.manualSelector, this.maxFailedIndexes, this.parallelism, this.podFailurePolicy, this.podReplacementPolicy, this.selector, this.successPolicy, this.suspend, this.template, this.ttlSecondsAfterFinished);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1JobSpec {\n");
        sb.append("    activeDeadlineSeconds: ").append(this.toIndentedString(this.activeDeadlineSeconds)).append("\n");
        sb.append("    backoffLimit: ").append(this.toIndentedString(this.backoffLimit)).append("\n");
        sb.append("    backoffLimitPerIndex: ").append(this.toIndentedString(this.backoffLimitPerIndex)).append("\n");
        sb.append("    completionMode: ").append(this.toIndentedString(this.completionMode)).append("\n");
        sb.append("    completions: ").append(this.toIndentedString(this.completions)).append("\n");
        sb.append("    managedBy: ").append(this.toIndentedString(this.managedBy)).append("\n");
        sb.append("    manualSelector: ").append(this.toIndentedString(this.manualSelector)).append("\n");
        sb.append("    maxFailedIndexes: ").append(this.toIndentedString(this.maxFailedIndexes)).append("\n");
        sb.append("    parallelism: ").append(this.toIndentedString(this.parallelism)).append("\n");
        sb.append("    podFailurePolicy: ").append(this.toIndentedString(this.podFailurePolicy)).append("\n");
        sb.append("    podReplacementPolicy: ").append(this.toIndentedString(this.podReplacementPolicy)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    successPolicy: ").append(this.toIndentedString(this.successPolicy)).append("\n");
        sb.append("    suspend: ").append(this.toIndentedString(this.suspend)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    ttlSecondsAfterFinished: ").append(this.toIndentedString(this.ttlSecondsAfterFinished)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1JobSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1JobSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_COMPLETION_MODE) != null && !jsonObj.get(SERIALIZED_NAME_COMPLETION_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMPLETION_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `completionMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPLETION_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MANAGED_BY) != null && !jsonObj.get(SERIALIZED_NAME_MANAGED_BY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MANAGED_BY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `managedBy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MANAGED_BY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_FAILURE_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_POD_FAILURE_POLICY).isJsonNull()) {
            V1PodFailurePolicy.validateJsonElement(jsonObj.get(SERIALIZED_NAME_POD_FAILURE_POLICY));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_REPLACEMENT_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_POD_REPLACEMENT_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POD_REPLACEMENT_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `podReplacementPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD_REPLACEMENT_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_SELECTOR).isJsonNull()) {
            V1LabelSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SELECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUCCESS_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_SUCCESS_POLICY).isJsonNull()) {
            V1SuccessPolicy.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SUCCESS_POLICY));
        }
        V1PodTemplateSpec.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TEMPLATE));
    }

    public static V1JobSpec fromJson(String jsonString) throws IOException {
        return (V1JobSpec)JSON.getGson().fromJson(jsonString, V1JobSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTIVE_DEADLINE_SECONDS);
        openapiFields.add(SERIALIZED_NAME_BACKOFF_LIMIT);
        openapiFields.add(SERIALIZED_NAME_BACKOFF_LIMIT_PER_INDEX);
        openapiFields.add(SERIALIZED_NAME_COMPLETION_MODE);
        openapiFields.add(SERIALIZED_NAME_COMPLETIONS);
        openapiFields.add(SERIALIZED_NAME_MANAGED_BY);
        openapiFields.add(SERIALIZED_NAME_MANUAL_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_MAX_FAILED_INDEXES);
        openapiFields.add(SERIALIZED_NAME_PARALLELISM);
        openapiFields.add(SERIALIZED_NAME_POD_FAILURE_POLICY);
        openapiFields.add(SERIALIZED_NAME_POD_REPLACEMENT_POLICY);
        openapiFields.add(SERIALIZED_NAME_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_SUCCESS_POLICY);
        openapiFields.add(SERIALIZED_NAME_SUSPEND);
        openapiFields.add(SERIALIZED_NAME_TEMPLATE);
        openapiFields.add(SERIALIZED_NAME_TTL_SECONDS_AFTER_FINISHED);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TEMPLATE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1JobSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1JobSpec.class));
            return new TypeAdapter<V1JobSpec>(){

                public void write(JsonWriter out, V1JobSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1JobSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1JobSpec.validateJsonElement(jsonElement);
                    return (V1JobSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

