/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ManagedFieldsEntry;
import io.kubernetes.client.openapi.models.V1OwnerReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.")
public class V1ObjectMeta {
    public static final String SERIALIZED_NAME_ANNOTATIONS = "annotations";
    @SerializedName(value="annotations")
    private Map<String, String> annotations = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_CREATION_TIMESTAMP = "creationTimestamp";
    @SerializedName(value="creationTimestamp")
    private OffsetDateTime creationTimestamp;
    public static final String SERIALIZED_NAME_DELETION_GRACE_PERIOD_SECONDS = "deletionGracePeriodSeconds";
    @SerializedName(value="deletionGracePeriodSeconds")
    private Long deletionGracePeriodSeconds;
    public static final String SERIALIZED_NAME_DELETION_TIMESTAMP = "deletionTimestamp";
    @SerializedName(value="deletionTimestamp")
    private OffsetDateTime deletionTimestamp;
    public static final String SERIALIZED_NAME_FINALIZERS = "finalizers";
    @SerializedName(value="finalizers")
    private List<String> finalizers = new ArrayList<String>();
    public static final String SERIALIZED_NAME_GENERATE_NAME = "generateName";
    @SerializedName(value="generateName")
    private String generateName;
    public static final String SERIALIZED_NAME_GENERATION = "generation";
    @SerializedName(value="generation")
    private Long generation;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private Map<String, String> labels = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_MANAGED_FIELDS = "managedFields";
    @SerializedName(value="managedFields")
    private List<V1ManagedFieldsEntry> managedFields = new ArrayList<V1ManagedFieldsEntry>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_OWNER_REFERENCES = "ownerReferences";
    @SerializedName(value="ownerReferences")
    private List<V1OwnerReference> ownerReferences = new ArrayList<V1OwnerReference>();
    public static final String SERIALIZED_NAME_RESOURCE_VERSION = "resourceVersion";
    @SerializedName(value="resourceVersion")
    private String resourceVersion;
    public static final String SERIALIZED_NAME_SELF_LINK = "selfLink";
    @SerializedName(value="selfLink")
    private String selfLink;
    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(value="uid")
    private String uid;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ObjectMeta annotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public V1ObjectMeta putAnnotationsItem(String key, String annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, annotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public V1ObjectMeta creationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.  Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata")
    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public V1ObjectMeta deletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
        this.deletionGracePeriodSeconds = deletionGracePeriodSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.")
    public Long getDeletionGracePeriodSeconds() {
        return this.deletionGracePeriodSeconds;
    }

    public void setDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
        this.deletionGracePeriodSeconds = deletionGracePeriodSeconds;
    }

    public V1ObjectMeta deletionTimestamp(OffsetDateTime deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.  Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata")
    public OffsetDateTime getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    public void setDeletionTimestamp(OffsetDateTime deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
    }

    public V1ObjectMeta finalizers(List<String> finalizers) {
        this.finalizers = finalizers;
        return this;
    }

    public V1ObjectMeta addFinalizersItem(String finalizersItem) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.add(finalizersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.")
    public List<String> getFinalizers() {
        return this.finalizers;
    }

    public void setFinalizers(List<String> finalizers) {
        this.finalizers = finalizers;
    }

    public V1ObjectMeta generateName(String generateName) {
        this.generateName = generateName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.  If this field is specified and the generated name exists, the server will return a 409.  Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency")
    public String getGenerateName() {
        return this.generateName;
    }

    public void setGenerateName(String generateName) {
        this.generateName = generateName;
    }

    public V1ObjectMeta generation(Long generation) {
        this.generation = generation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.")
    public Long getGeneration() {
        return this.generation;
    }

    public void setGeneration(Long generation) {
        this.generation = generation;
    }

    public V1ObjectMeta labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public V1ObjectMeta putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public V1ObjectMeta managedFields(List<V1ManagedFieldsEntry> managedFields) {
        this.managedFields = managedFields;
        return this;
    }

    public V1ObjectMeta addManagedFieldsItem(V1ManagedFieldsEntry managedFieldsItem) {
        if (this.managedFields == null) {
            this.managedFields = new ArrayList<V1ManagedFieldsEntry>();
        }
        this.managedFields.add(managedFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \"ci-cd\". The set of fields is always in the version that the workflow used when modifying the object.")
    public List<V1ManagedFieldsEntry> getManagedFields() {
        return this.managedFields;
    }

    public void setManagedFields(List<V1ManagedFieldsEntry> managedFields) {
        this.managedFields = managedFields;
    }

    public V1ObjectMeta name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ObjectMeta namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the \"default\" namespace, but \"default\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.  Must be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public V1ObjectMeta ownerReferences(List<V1OwnerReference> ownerReferences) {
        this.ownerReferences = ownerReferences;
        return this;
    }

    public V1ObjectMeta addOwnerReferencesItem(V1OwnerReference ownerReferencesItem) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<V1OwnerReference>();
        }
        this.ownerReferences.add(ownerReferencesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.")
    public List<V1OwnerReference> getOwnerReferences() {
        return this.ownerReferences;
    }

    public void setOwnerReferences(List<V1OwnerReference> ownerReferences) {
        this.ownerReferences = ownerReferences;
    }

    public V1ObjectMeta resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.  Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public V1ObjectMeta selfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.")
    public String getSelfLink() {
        return this.selfLink;
    }

    public void setSelfLink(String selfLink) {
        this.selfLink = selfLink;
    }

    public V1ObjectMeta uid(String uid) {
        this.uid = uid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.  Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ObjectMeta v1ObjectMeta = (V1ObjectMeta)o;
        return Objects.equals(this.annotations, v1ObjectMeta.annotations) && Objects.equals(this.creationTimestamp, v1ObjectMeta.creationTimestamp) && Objects.equals(this.deletionGracePeriodSeconds, v1ObjectMeta.deletionGracePeriodSeconds) && Objects.equals(this.deletionTimestamp, v1ObjectMeta.deletionTimestamp) && Objects.equals(this.finalizers, v1ObjectMeta.finalizers) && Objects.equals(this.generateName, v1ObjectMeta.generateName) && Objects.equals(this.generation, v1ObjectMeta.generation) && Objects.equals(this.labels, v1ObjectMeta.labels) && Objects.equals(this.managedFields, v1ObjectMeta.managedFields) && Objects.equals(this.name, v1ObjectMeta.name) && Objects.equals(this.namespace, v1ObjectMeta.namespace) && Objects.equals(this.ownerReferences, v1ObjectMeta.ownerReferences) && Objects.equals(this.resourceVersion, v1ObjectMeta.resourceVersion) && Objects.equals(this.selfLink, v1ObjectMeta.selfLink) && Objects.equals(this.uid, v1ObjectMeta.uid);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.creationTimestamp, this.deletionGracePeriodSeconds, this.deletionTimestamp, this.finalizers, this.generateName, this.generation, this.labels, this.managedFields, this.name, this.namespace, this.ownerReferences, this.resourceVersion, this.selfLink, this.uid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ObjectMeta {\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    creationTimestamp: ").append(this.toIndentedString(this.creationTimestamp)).append("\n");
        sb.append("    deletionGracePeriodSeconds: ").append(this.toIndentedString(this.deletionGracePeriodSeconds)).append("\n");
        sb.append("    deletionTimestamp: ").append(this.toIndentedString(this.deletionTimestamp)).append("\n");
        sb.append("    finalizers: ").append(this.toIndentedString(this.finalizers)).append("\n");
        sb.append("    generateName: ").append(this.toIndentedString(this.generateName)).append("\n");
        sb.append("    generation: ").append(this.toIndentedString(this.generation)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    managedFields: ").append(this.toIndentedString(this.managedFields)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    ownerReferences: ").append(this.toIndentedString(this.ownerReferences)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    selfLink: ").append(this.toIndentedString(this.selfLink)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayownerReferences;
        int i;
        JsonArray jsonArraymanagedFields;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ObjectMeta is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ObjectMeta` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_FINALIZERS) != null && !jsonObj.get(SERIALIZED_NAME_FINALIZERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FINALIZERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `finalizers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FINALIZERS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GENERATE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_GENERATE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GENERATE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `generateName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GENERATE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MANAGED_FIELDS) != null && !jsonObj.get(SERIALIZED_NAME_MANAGED_FIELDS).isJsonNull() && (jsonArraymanagedFields = jsonObj.getAsJsonArray(SERIALIZED_NAME_MANAGED_FIELDS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MANAGED_FIELDS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `managedFields` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MANAGED_FIELDS).toString()));
            }
            for (i = 0; i < jsonArraymanagedFields.size(); ++i) {
                V1ManagedFieldsEntry.validateJsonElement(jsonArraymanagedFields.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OWNER_REFERENCES) != null && !jsonObj.get(SERIALIZED_NAME_OWNER_REFERENCES).isJsonNull() && (jsonArrayownerReferences = jsonObj.getAsJsonArray(SERIALIZED_NAME_OWNER_REFERENCES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_OWNER_REFERENCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `ownerReferences` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OWNER_REFERENCES).toString()));
            }
            for (i = 0; i < jsonArrayownerReferences.size(); ++i) {
                V1OwnerReference.validateJsonElement(jsonArrayownerReferences.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELF_LINK) != null && !jsonObj.get(SERIALIZED_NAME_SELF_LINK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SELF_LINK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `selfLink` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELF_LINK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UID) != null && !jsonObj.get(SERIALIZED_NAME_UID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UID).toString()));
        }
    }

    public static V1ObjectMeta fromJson(String jsonString) throws IOException {
        return (V1ObjectMeta)JSON.getGson().fromJson(jsonString, V1ObjectMeta.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ANNOTATIONS);
        openapiFields.add(SERIALIZED_NAME_CREATION_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_DELETION_GRACE_PERIOD_SECONDS);
        openapiFields.add(SERIALIZED_NAME_DELETION_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_FINALIZERS);
        openapiFields.add(SERIALIZED_NAME_GENERATE_NAME);
        openapiFields.add(SERIALIZED_NAME_GENERATION);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_MANAGED_FIELDS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_OWNER_REFERENCES);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_VERSION);
        openapiFields.add(SERIALIZED_NAME_SELF_LINK);
        openapiFields.add(SERIALIZED_NAME_UID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ObjectMeta.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ObjectMeta.class));
            return new TypeAdapter<V1ObjectMeta>(){

                public void write(JsonWriter out, V1ObjectMeta value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ObjectMeta read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ObjectMeta.validateJsonElement(jsonElement);
                    return (V1ObjectMeta)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

