/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceAttribute must have exactly one field set.")
public class V1beta1DeviceAttribute {
    public static final String SERIALIZED_NAME_BOOL = "bool";
    @SerializedName(value="bool")
    private Boolean bool;
    public static final String SERIALIZED_NAME_INT = "int";
    @SerializedName(value="int")
    private Long _int;
    public static final String SERIALIZED_NAME_STRING = "string";
    @SerializedName(value="string")
    private String string;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1DeviceAttribute bool(Boolean bool) {
        this.bool = bool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BoolValue is a true/false value.")
    public Boolean getBool() {
        return this.bool;
    }

    public void setBool(Boolean bool) {
        this.bool = bool;
    }

    public V1beta1DeviceAttribute _int(Long _int) {
        this._int = _int;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IntValue is a number.")
    public Long getInt() {
        return this._int;
    }

    public void setInt(Long _int) {
        this._int = _int;
    }

    public V1beta1DeviceAttribute string(String string) {
        this.string = string;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StringValue is a string. Must not be longer than 64 characters.")
    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public V1beta1DeviceAttribute version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VersionValue is a semantic version according to semver.org spec 2.0.0. Must not be longer than 64 characters.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1DeviceAttribute v1beta1DeviceAttribute = (V1beta1DeviceAttribute)o;
        return Objects.equals(this.bool, v1beta1DeviceAttribute.bool) && Objects.equals(this._int, v1beta1DeviceAttribute._int) && Objects.equals(this.string, v1beta1DeviceAttribute.string) && Objects.equals(this.version, v1beta1DeviceAttribute.version);
    }

    public int hashCode() {
        return Objects.hash(this.bool, this._int, this.string, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1DeviceAttribute {\n");
        sb.append("    bool: ").append(this.toIndentedString(this.bool)).append("\n");
        sb.append("    _int: ").append(this.toIndentedString(this._int)).append("\n");
        sb.append("    string: ").append(this.toIndentedString(this.string)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1DeviceAttribute is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1DeviceAttribute` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_STRING) != null && !jsonObj.get(SERIALIZED_NAME_STRING).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STRING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `string` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STRING).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
    }

    public static V1beta1DeviceAttribute fromJson(String jsonString) throws IOException {
        return (V1beta1DeviceAttribute)JSON.getGson().fromJson(jsonString, V1beta1DeviceAttribute.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BOOL);
        openapiFields.add(SERIALIZED_NAME_INT);
        openapiFields.add(SERIALIZED_NAME_STRING);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1DeviceAttribute.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1DeviceAttribute.class));
            return new TypeAdapter<V1beta1DeviceAttribute>(){

                public void write(JsonWriter out, V1beta1DeviceAttribute value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1DeviceAttribute read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1DeviceAttribute.validateJsonElement(jsonElement);
                    return (V1beta1DeviceAttribute)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

