package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Byte;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ApiextensionsV1beta1WebhookClientConfigFluentImpl<A extends ApiextensionsV1beta1WebhookClientConfigFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements ApiextensionsV1beta1WebhookClientConfigFluent<A>{

    private List<Byte> caBundle;
    private ApiextensionsV1beta1ServiceReferenceBuilder service;
    private String url;

    public ApiextensionsV1beta1WebhookClientConfigFluentImpl(){
    }
    public ApiextensionsV1beta1WebhookClientConfigFluentImpl(ApiextensionsV1beta1WebhookClientConfig instance){
            this.withCaBundle(instance.getCaBundle());

            this.withService(instance.getService());

            this.withUrl(instance.getUrl());

    }

    public A withCaBundle(byte... caBundle){
            if (this.caBundle != null) {this.caBundle.clear();}
            if (caBundle != null) {for (byte item :caBundle){ this.addToCaBundle(item);}} return (A) this;
    }

    public byte[] getCaBundle(){
            //This needs to work with primitives, so we use arrays.
int size = caBundle != null ? caBundle.size() : 0;
byte[] result = new byte[size];
if (size == 0) {
   return result;
}
int index = 0;
for (byte item : caBundle) {
    result[index++]=item;
}
return result;

    }

    public A addToCaBundle(int index,Byte item){
            if (this.caBundle == null) {this.caBundle = null;}
            this.caBundle.add(index, item);
            return (A)this;
    }

    public A setToCaBundle(int index,Byte item){
            if (this.caBundle == null) {this.caBundle = null;}
            this.caBundle.set(index, item); return (A)this;
    }

    public A addToCaBundle(Byte... items){
            if (this.caBundle == null) {this.caBundle = null;}
            for (Byte item : items) {this.caBundle.add(item);} return (A)this;
    }

    public A addAllToCaBundle(Collection<Byte> items){
            if (this.caBundle == null) {this.caBundle = null;}
            for (Byte item : items) {this.caBundle.add(item);} return (A)this;
    }

    public A removeFromCaBundle(Byte... items){
            for (Byte item : items) {if (this.caBundle!= null){ this.caBundle.remove(item);}} return (A)this;
    }

    public A removeAllFromCaBundle(Collection<Byte> items){
            for (Byte item : items) {if (this.caBundle!= null){ this.caBundle.remove(item);}} return (A)this;
    }

    public Boolean hasCaBundle(){
            return caBundle != null && !caBundle.isEmpty();
    }

    public A addNewCaBundle(String arg1){
            return (A)addToCaBundle(new Byte(arg1));
    }

    public A addNewCaBundle(byte arg1){
            return (A)addToCaBundle(new Byte(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildService instead.
 * @return The buildable object.
 */
@Deprecated public ApiextensionsV1beta1ServiceReference getService(){
            return this.service!=null?this.service.build():null;
    }

    public ApiextensionsV1beta1ServiceReference buildService(){
            return this.service!=null?this.service.build():null;
    }

    public A withService(ApiextensionsV1beta1ServiceReference service){
            _visitables.get("service").remove(this.service);
            if (service!=null){ this.service= new ApiextensionsV1beta1ServiceReferenceBuilder(service); _visitables.get("service").add(this.service);} return (A) this;
    }

    public Boolean hasService(){
            return this.service != null;
    }

    public ApiextensionsV1beta1WebhookClientConfigFluent.ServiceNested<A> withNewService(){
            return new ServiceNestedImpl();
    }

    public ApiextensionsV1beta1WebhookClientConfigFluent.ServiceNested<A> withNewServiceLike(ApiextensionsV1beta1ServiceReference item){
            return new ServiceNestedImpl(item);
    }

    public ApiextensionsV1beta1WebhookClientConfigFluent.ServiceNested<A> editService(){
            return withNewServiceLike(getService());
    }

    public ApiextensionsV1beta1WebhookClientConfigFluent.ServiceNested<A> editOrNewService(){
            return withNewServiceLike(getService() != null ? getService(): new ApiextensionsV1beta1ServiceReferenceBuilder().build());
    }

    public ApiextensionsV1beta1WebhookClientConfigFluent.ServiceNested<A> editOrNewServiceLike(ApiextensionsV1beta1ServiceReference item){
            return withNewServiceLike(getService() != null ? getService(): item);
    }

    public String getUrl(){
            return this.url;
    }

    public A withUrl(String url){
            this.url=url; return (A) this;
    }

    public Boolean hasUrl(){
            return this.url != null;
    }

    public A withNewUrl(String arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1){
            return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ApiextensionsV1beta1WebhookClientConfigFluentImpl that = (ApiextensionsV1beta1WebhookClientConfigFluentImpl) o;
            if (caBundle != null ? !caBundle.equals(that.caBundle) :that.caBundle != null) return false;
            if (service != null ? !service.equals(that.service) :that.service != null) return false;
            if (url != null ? !url.equals(that.url) :that.url != null) return false;
            return true;
    }


    public class ServiceNestedImpl<N> extends ApiextensionsV1beta1ServiceReferenceFluentImpl<ApiextensionsV1beta1WebhookClientConfigFluent.ServiceNested<N>> implements ApiextensionsV1beta1WebhookClientConfigFluent.ServiceNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ApiextensionsV1beta1ServiceReferenceBuilder builder;
    
            ServiceNestedImpl(ApiextensionsV1beta1ServiceReference item){
                    this.builder = new ApiextensionsV1beta1ServiceReferenceBuilder(this, item);
            }
            ServiceNestedImpl(){
                    this.builder = new ApiextensionsV1beta1ServiceReferenceBuilder(this);
            }
    
    public N and(){
            return (N) ApiextensionsV1beta1WebhookClientConfigFluentImpl.this.withService(builder.build());
    }
    public N endService(){
            return and();
    }

}


}
