package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ExtensionsV1beta1DeploymentStatusFluent<A extends ExtensionsV1beta1DeploymentStatusFluent<A>> extends Fluent<A>{


    public Integer getAvailableReplicas();
    public A withAvailableReplicas(Integer availableReplicas);
    public Boolean hasAvailableReplicas();
    public Integer getCollisionCount();
    public A withCollisionCount(Integer collisionCount);
    public Boolean hasCollisionCount();
    public A addToConditions(int index,ExtensionsV1beta1DeploymentCondition item);
    public A setToConditions(int index,ExtensionsV1beta1DeploymentCondition item);
    public A addToConditions(ExtensionsV1beta1DeploymentCondition... items);
    public A addAllToConditions(Collection<ExtensionsV1beta1DeploymentCondition> items);
    public A removeFromConditions(ExtensionsV1beta1DeploymentCondition... items);
    public A removeAllFromConditions(Collection<ExtensionsV1beta1DeploymentCondition> items);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1DeploymentCondition> getConditions();
    public List<ExtensionsV1beta1DeploymentCondition> buildConditions();
    public ExtensionsV1beta1DeploymentCondition buildCondition(int index);
    public ExtensionsV1beta1DeploymentCondition buildFirstCondition();
    public ExtensionsV1beta1DeploymentCondition buildLastCondition();
    public ExtensionsV1beta1DeploymentCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1DeploymentConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1DeploymentConditionBuilder> predicate);
    public A withConditions(List<ExtensionsV1beta1DeploymentCondition> conditions);
    public A withConditions(ExtensionsV1beta1DeploymentCondition... conditions);
    public Boolean hasConditions();
    public ExtensionsV1beta1DeploymentStatusFluent.ConditionsNested<A> addNewCondition();
    public ExtensionsV1beta1DeploymentStatusFluent.ConditionsNested<A> addNewConditionLike(ExtensionsV1beta1DeploymentCondition item);
    public ExtensionsV1beta1DeploymentStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ExtensionsV1beta1DeploymentCondition item);
    public ExtensionsV1beta1DeploymentStatusFluent.ConditionsNested<A> editCondition(int index);
    public ExtensionsV1beta1DeploymentStatusFluent.ConditionsNested<A> editFirstCondition();
    public ExtensionsV1beta1DeploymentStatusFluent.ConditionsNested<A> editLastCondition();
    public ExtensionsV1beta1DeploymentStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1DeploymentConditionBuilder> predicate);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public Integer getUnavailableReplicas();
    public A withUnavailableReplicas(Integer unavailableReplicas);
    public Boolean hasUnavailableReplicas();
    public Integer getUpdatedReplicas();
    public A withUpdatedReplicas(Integer updatedReplicas);
    public Boolean hasUpdatedReplicas();

    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1DeploymentConditionFluent<ExtensionsV1beta1DeploymentStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}


}
