package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class PolicyV1beta1PodSecurityPolicyListFluentImpl<A extends PolicyV1beta1PodSecurityPolicyListFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements PolicyV1beta1PodSecurityPolicyListFluent<A>{

    private String apiVersion;
    private List<PolicyV1beta1PodSecurityPolicyBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public PolicyV1beta1PodSecurityPolicyListFluentImpl(){
    }
    public PolicyV1beta1PodSecurityPolicyListFluentImpl(PolicyV1beta1PodSecurityPolicyList instance){
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,PolicyV1beta1PodSecurityPolicy item){
            if (this.items == null) {this.items = new ArrayList<PolicyV1beta1PodSecurityPolicyBuilder>();}
            PolicyV1beta1PodSecurityPolicyBuilder builder = new PolicyV1beta1PodSecurityPolicyBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,PolicyV1beta1PodSecurityPolicy item){
            if (this.items == null) {this.items = new ArrayList<PolicyV1beta1PodSecurityPolicyBuilder>();}
            PolicyV1beta1PodSecurityPolicyBuilder builder = new PolicyV1beta1PodSecurityPolicyBuilder(item);
            if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(PolicyV1beta1PodSecurityPolicy... items){
            if (this.items == null) {this.items = new ArrayList<PolicyV1beta1PodSecurityPolicyBuilder>();}
            for (PolicyV1beta1PodSecurityPolicy item : items) {PolicyV1beta1PodSecurityPolicyBuilder builder = new PolicyV1beta1PodSecurityPolicyBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<PolicyV1beta1PodSecurityPolicy> items){
            if (this.items == null) {this.items = new ArrayList<PolicyV1beta1PodSecurityPolicyBuilder>();}
            for (PolicyV1beta1PodSecurityPolicy item : items) {PolicyV1beta1PodSecurityPolicyBuilder builder = new PolicyV1beta1PodSecurityPolicyBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(PolicyV1beta1PodSecurityPolicy... items){
            for (PolicyV1beta1PodSecurityPolicy item : items) {PolicyV1beta1PodSecurityPolicyBuilder builder = new PolicyV1beta1PodSecurityPolicyBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<PolicyV1beta1PodSecurityPolicy> items){
            for (PolicyV1beta1PodSecurityPolicy item : items) {PolicyV1beta1PodSecurityPolicyBuilder builder = new PolicyV1beta1PodSecurityPolicyBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<PolicyV1beta1PodSecurityPolicy> getItems(){
            return build(items);
    }

    public List<PolicyV1beta1PodSecurityPolicy> buildItems(){
            return build(items);
    }

    public PolicyV1beta1PodSecurityPolicy buildItem(int index){
            return this.items.get(index).build();
    }

    public PolicyV1beta1PodSecurityPolicy buildFirstItem(){
            return this.items.get(0).build();
    }

    public PolicyV1beta1PodSecurityPolicy buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public PolicyV1beta1PodSecurityPolicy buildMatchingItem(io.kubernetes.client.fluent.Predicate<PolicyV1beta1PodSecurityPolicyBuilder> predicate){
            for (PolicyV1beta1PodSecurityPolicyBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<PolicyV1beta1PodSecurityPolicyBuilder> predicate){
            for (PolicyV1beta1PodSecurityPolicyBuilder item: items) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withItems(List<PolicyV1beta1PodSecurityPolicy> items){
            if (this.items != null) { _visitables.get("items").removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<PolicyV1beta1PodSecurityPolicyBuilder>(); for (PolicyV1beta1PodSecurityPolicy item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(PolicyV1beta1PodSecurityPolicy... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (PolicyV1beta1PodSecurityPolicy item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.ItemsNested<A> addNewItemLike(PolicyV1beta1PodSecurityPolicy item){
            return new ItemsNestedImpl(-1, item);
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.ItemsNested<A> setNewItemLike(int index,PolicyV1beta1PodSecurityPolicy item){
            return new ItemsNestedImpl(index, item);
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<PolicyV1beta1PodSecurityPolicyBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ListMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ListMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ListMetaBuilder().build());
    }

    public PolicyV1beta1PodSecurityPolicyListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyV1beta1PodSecurityPolicyListFluentImpl that = (PolicyV1beta1PodSecurityPolicyListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends PolicyV1beta1PodSecurityPolicyFluentImpl<PolicyV1beta1PodSecurityPolicyListFluent.ItemsNested<N>> implements PolicyV1beta1PodSecurityPolicyListFluent.ItemsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final PolicyV1beta1PodSecurityPolicyBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,PolicyV1beta1PodSecurityPolicy item){
                    this.index = index;
                    this.builder = new PolicyV1beta1PodSecurityPolicyBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new PolicyV1beta1PodSecurityPolicyBuilder(this);
            }
    
    public N and(){
            return (N) PolicyV1beta1PodSecurityPolicyListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ListMetaFluentImpl<PolicyV1beta1PodSecurityPolicyListFluent.MetadataNested<N>> implements PolicyV1beta1PodSecurityPolicyListFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ListMetaBuilder builder;
    
            MetadataNestedImpl(V1ListMeta item){
                    this.builder = new V1ListMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ListMetaBuilder(this);
            }
    
    public N and(){
            return (N) PolicyV1beta1PodSecurityPolicyListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
