package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;

public interface PolicyV1beta1PodSecurityPolicySpecFluent<A extends PolicyV1beta1PodSecurityPolicySpecFluent<A>> extends Fluent<A>{


    public Boolean isAllowPrivilegeEscalation();
    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation);
    public Boolean hasAllowPrivilegeEscalation();
    public A withNewAllowPrivilegeEscalation(String arg1);
    public A withNewAllowPrivilegeEscalation(boolean arg1);
    public A addToAllowedCapabilities(int index,String item);
    public A setToAllowedCapabilities(int index,String item);
    public A addToAllowedCapabilities(String... items);
    public A addAllToAllowedCapabilities(Collection<String> items);
    public A removeFromAllowedCapabilities(String... items);
    public A removeAllFromAllowedCapabilities(Collection<String> items);
    public List<String> getAllowedCapabilities();
    public String getAllowedCapability(int index);
    public String getFirstAllowedCapability();
    public String getLastAllowedCapability();
    public String getMatchingAllowedCapability(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingAllowedCapability(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withAllowedCapabilities(List<String> allowedCapabilities);
    public A withAllowedCapabilities(String... allowedCapabilities);
    public Boolean hasAllowedCapabilities();
    public A addNewAllowedCapability(String arg1);
    public A addNewAllowedCapability(StringBuilder arg1);
    public A addNewAllowedCapability(StringBuffer arg1);
    public A addToAllowedFlexVolumes(int index,PolicyV1beta1AllowedFlexVolume item);
    public A setToAllowedFlexVolumes(int index,PolicyV1beta1AllowedFlexVolume item);
    public A addToAllowedFlexVolumes(PolicyV1beta1AllowedFlexVolume... items);
    public A addAllToAllowedFlexVolumes(Collection<PolicyV1beta1AllowedFlexVolume> items);
    public A removeFromAllowedFlexVolumes(PolicyV1beta1AllowedFlexVolume... items);
    public A removeAllFromAllowedFlexVolumes(Collection<PolicyV1beta1AllowedFlexVolume> items);
    
/**
 * This method has been deprecated, please use method buildAllowedFlexVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<PolicyV1beta1AllowedFlexVolume> getAllowedFlexVolumes();
    public List<PolicyV1beta1AllowedFlexVolume> buildAllowedFlexVolumes();
    public PolicyV1beta1AllowedFlexVolume buildAllowedFlexVolume(int index);
    public PolicyV1beta1AllowedFlexVolume buildFirstAllowedFlexVolume();
    public PolicyV1beta1AllowedFlexVolume buildLastAllowedFlexVolume();
    public PolicyV1beta1AllowedFlexVolume buildMatchingAllowedFlexVolume(io.kubernetes.client.fluent.Predicate<PolicyV1beta1AllowedFlexVolumeBuilder> predicate);
    public Boolean hasMatchingAllowedFlexVolume(io.kubernetes.client.fluent.Predicate<PolicyV1beta1AllowedFlexVolumeBuilder> predicate);
    public A withAllowedFlexVolumes(List<PolicyV1beta1AllowedFlexVolume> allowedFlexVolumes);
    public A withAllowedFlexVolumes(PolicyV1beta1AllowedFlexVolume... allowedFlexVolumes);
    public Boolean hasAllowedFlexVolumes();
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume();
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(PolicyV1beta1AllowedFlexVolume item);
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(int index,PolicyV1beta1AllowedFlexVolume item);
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(int index);
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume();
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume();
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(io.kubernetes.client.fluent.Predicate<PolicyV1beta1AllowedFlexVolumeBuilder> predicate);
    public A addToAllowedHostPaths(int index,PolicyV1beta1AllowedHostPath item);
    public A setToAllowedHostPaths(int index,PolicyV1beta1AllowedHostPath item);
    public A addToAllowedHostPaths(PolicyV1beta1AllowedHostPath... items);
    public A addAllToAllowedHostPaths(Collection<PolicyV1beta1AllowedHostPath> items);
    public A removeFromAllowedHostPaths(PolicyV1beta1AllowedHostPath... items);
    public A removeAllFromAllowedHostPaths(Collection<PolicyV1beta1AllowedHostPath> items);
    
/**
 * This method has been deprecated, please use method buildAllowedHostPaths instead.
 * @return The buildable object.
 */
@Deprecated public List<PolicyV1beta1AllowedHostPath> getAllowedHostPaths();
    public List<PolicyV1beta1AllowedHostPath> buildAllowedHostPaths();
    public PolicyV1beta1AllowedHostPath buildAllowedHostPath(int index);
    public PolicyV1beta1AllowedHostPath buildFirstAllowedHostPath();
    public PolicyV1beta1AllowedHostPath buildLastAllowedHostPath();
    public PolicyV1beta1AllowedHostPath buildMatchingAllowedHostPath(io.kubernetes.client.fluent.Predicate<PolicyV1beta1AllowedHostPathBuilder> predicate);
    public Boolean hasMatchingAllowedHostPath(io.kubernetes.client.fluent.Predicate<PolicyV1beta1AllowedHostPathBuilder> predicate);
    public A withAllowedHostPaths(List<PolicyV1beta1AllowedHostPath> allowedHostPaths);
    public A withAllowedHostPaths(PolicyV1beta1AllowedHostPath... allowedHostPaths);
    public Boolean hasAllowedHostPaths();
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPath();
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPathLike(PolicyV1beta1AllowedHostPath item);
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> setNewAllowedHostPathLike(int index,PolicyV1beta1AllowedHostPath item);
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editAllowedHostPath(int index);
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editFirstAllowedHostPath();
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editLastAllowedHostPath();
    public PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editMatchingAllowedHostPath(io.kubernetes.client.fluent.Predicate<PolicyV1beta1AllowedHostPathBuilder> predicate);
    public A addToAllowedProcMountTypes(int index,String item);
    public A setToAllowedProcMountTypes(int index,String item);
    public A addToAllowedProcMountTypes(String... items);
    public A addAllToAllowedProcMountTypes(Collection<String> items);
    public A removeFromAllowedProcMountTypes(String... items);
    public A removeAllFromAllowedProcMountTypes(Collection<String> items);
    public List<String> getAllowedProcMountTypes();
    public String getAllowedProcMountType(int index);
    public String getFirstAllowedProcMountType();
    public String getLastAllowedProcMountType();
    public String getMatchingAllowedProcMountType(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingAllowedProcMountType(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withAllowedProcMountTypes(List<String> allowedProcMountTypes);
    public A withAllowedProcMountTypes(String... allowedProcMountTypes);
    public Boolean hasAllowedProcMountTypes();
    public A addNewAllowedProcMountType(String arg1);
    public A addNewAllowedProcMountType(StringBuilder arg1);
    public A addNewAllowedProcMountType(StringBuffer arg1);
    public A addToAllowedUnsafeSysctls(int index,String item);
    public A setToAllowedUnsafeSysctls(int index,String item);
    public A addToAllowedUnsafeSysctls(String... items);
    public A addAllToAllowedUnsafeSysctls(Collection<String> items);
    public A removeFromAllowedUnsafeSysctls(String... items);
    public A removeAllFromAllowedUnsafeSysctls(Collection<String> items);
    public List<String> getAllowedUnsafeSysctls();
    public String getAllowedUnsafeSysctl(int index);
    public String getFirstAllowedUnsafeSysctl();
    public String getLastAllowedUnsafeSysctl();
    public String getMatchingAllowedUnsafeSysctl(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingAllowedUnsafeSysctl(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls);
    public A withAllowedUnsafeSysctls(String... allowedUnsafeSysctls);
    public Boolean hasAllowedUnsafeSysctls();
    public A addNewAllowedUnsafeSysctl(String arg1);
    public A addNewAllowedUnsafeSysctl(StringBuilder arg1);
    public A addNewAllowedUnsafeSysctl(StringBuffer arg1);
    public A addToDefaultAddCapabilities(int index,String item);
    public A setToDefaultAddCapabilities(int index,String item);
    public A addToDefaultAddCapabilities(String... items);
    public A addAllToDefaultAddCapabilities(Collection<String> items);
    public A removeFromDefaultAddCapabilities(String... items);
    public A removeAllFromDefaultAddCapabilities(Collection<String> items);
    public List<String> getDefaultAddCapabilities();
    public String getDefaultAddCapability(int index);
    public String getFirstDefaultAddCapability();
    public String getLastDefaultAddCapability();
    public String getMatchingDefaultAddCapability(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingDefaultAddCapability(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities);
    public A withDefaultAddCapabilities(String... defaultAddCapabilities);
    public Boolean hasDefaultAddCapabilities();
    public A addNewDefaultAddCapability(String arg1);
    public A addNewDefaultAddCapability(StringBuilder arg1);
    public A addNewDefaultAddCapability(StringBuffer arg1);
    public Boolean isDefaultAllowPrivilegeEscalation();
    public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation);
    public Boolean hasDefaultAllowPrivilegeEscalation();
    public A withNewDefaultAllowPrivilegeEscalation(String arg1);
    public A withNewDefaultAllowPrivilegeEscalation(boolean arg1);
    public A addToForbiddenSysctls(int index,String item);
    public A setToForbiddenSysctls(int index,String item);
    public A addToForbiddenSysctls(String... items);
    public A addAllToForbiddenSysctls(Collection<String> items);
    public A removeFromForbiddenSysctls(String... items);
    public A removeAllFromForbiddenSysctls(Collection<String> items);
    public List<String> getForbiddenSysctls();
    public String getForbiddenSysctl(int index);
    public String getFirstForbiddenSysctl();
    public String getLastForbiddenSysctl();
    public String getMatchingForbiddenSysctl(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingForbiddenSysctl(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withForbiddenSysctls(List<String> forbiddenSysctls);
    public A withForbiddenSysctls(String... forbiddenSysctls);
    public Boolean hasForbiddenSysctls();
    public A addNewForbiddenSysctl(String arg1);
    public A addNewForbiddenSysctl(StringBuilder arg1);
    public A addNewForbiddenSysctl(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildFsGroup instead.
 * @return The buildable object.
 */
@Deprecated public PolicyV1beta1FSGroupStrategyOptions getFsGroup();
    public PolicyV1beta1FSGroupStrategyOptions buildFsGroup();
    public A withFsGroup(PolicyV1beta1FSGroupStrategyOptions fsGroup);
    public Boolean hasFsGroup();
    public PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroup();
    public PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroupLike(PolicyV1beta1FSGroupStrategyOptions item);
    public PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editFsGroup();
    public PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroup();
    public PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroupLike(PolicyV1beta1FSGroupStrategyOptions item);
    public Boolean isHostIPC();
    public A withHostIPC(Boolean hostIPC);
    public Boolean hasHostIPC();
    public A withNewHostIPC(String arg1);
    public A withNewHostIPC(boolean arg1);
    public Boolean isHostNetwork();
    public A withHostNetwork(Boolean hostNetwork);
    public Boolean hasHostNetwork();
    public A withNewHostNetwork(String arg1);
    public A withNewHostNetwork(boolean arg1);
    public Boolean isHostPID();
    public A withHostPID(Boolean hostPID);
    public Boolean hasHostPID();
    public A withNewHostPID(String arg1);
    public A withNewHostPID(boolean arg1);
    public A addToHostPorts(int index,PolicyV1beta1HostPortRange item);
    public A setToHostPorts(int index,PolicyV1beta1HostPortRange item);
    public A addToHostPorts(PolicyV1beta1HostPortRange... items);
    public A addAllToHostPorts(Collection<PolicyV1beta1HostPortRange> items);
    public A removeFromHostPorts(PolicyV1beta1HostPortRange... items);
    public A removeAllFromHostPorts(Collection<PolicyV1beta1HostPortRange> items);
    
/**
 * This method has been deprecated, please use method buildHostPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<PolicyV1beta1HostPortRange> getHostPorts();
    public List<PolicyV1beta1HostPortRange> buildHostPorts();
    public PolicyV1beta1HostPortRange buildHostPort(int index);
    public PolicyV1beta1HostPortRange buildFirstHostPort();
    public PolicyV1beta1HostPortRange buildLastHostPort();
    public PolicyV1beta1HostPortRange buildMatchingHostPort(io.kubernetes.client.fluent.Predicate<PolicyV1beta1HostPortRangeBuilder> predicate);
    public Boolean hasMatchingHostPort(io.kubernetes.client.fluent.Predicate<PolicyV1beta1HostPortRangeBuilder> predicate);
    public A withHostPorts(List<PolicyV1beta1HostPortRange> hostPorts);
    public A withHostPorts(PolicyV1beta1HostPortRange... hostPorts);
    public Boolean hasHostPorts();
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPort();
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPortLike(PolicyV1beta1HostPortRange item);
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> setNewHostPortLike(int index,PolicyV1beta1HostPortRange item);
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editHostPort(int index);
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editFirstHostPort();
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editLastHostPort();
    public PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editMatchingHostPort(io.kubernetes.client.fluent.Predicate<PolicyV1beta1HostPortRangeBuilder> predicate);
    public Boolean isPrivileged();
    public A withPrivileged(Boolean privileged);
    public Boolean hasPrivileged();
    public A withNewPrivileged(String arg1);
    public A withNewPrivileged(boolean arg1);
    public Boolean isReadOnlyRootFilesystem();
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
    public Boolean hasReadOnlyRootFilesystem();
    public A withNewReadOnlyRootFilesystem(String arg1);
    public A withNewReadOnlyRootFilesystem(boolean arg1);
    public A addToRequiredDropCapabilities(int index,String item);
    public A setToRequiredDropCapabilities(int index,String item);
    public A addToRequiredDropCapabilities(String... items);
    public A addAllToRequiredDropCapabilities(Collection<String> items);
    public A removeFromRequiredDropCapabilities(String... items);
    public A removeAllFromRequiredDropCapabilities(Collection<String> items);
    public List<String> getRequiredDropCapabilities();
    public String getRequiredDropCapability(int index);
    public String getFirstRequiredDropCapability();
    public String getLastRequiredDropCapability();
    public String getMatchingRequiredDropCapability(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingRequiredDropCapability(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities);
    public A withRequiredDropCapabilities(String... requiredDropCapabilities);
    public Boolean hasRequiredDropCapabilities();
    public A addNewRequiredDropCapability(String arg1);
    public A addNewRequiredDropCapability(StringBuilder arg1);
    public A addNewRequiredDropCapability(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildRunAsGroup instead.
 * @return The buildable object.
 */
@Deprecated public PolicyV1beta1RunAsGroupStrategyOptions getRunAsGroup();
    public PolicyV1beta1RunAsGroupStrategyOptions buildRunAsGroup();
    public A withRunAsGroup(PolicyV1beta1RunAsGroupStrategyOptions runAsGroup);
    public Boolean hasRunAsGroup();
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroup();
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroupLike(PolicyV1beta1RunAsGroupStrategyOptions item);
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<A> editRunAsGroup();
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroup();
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroupLike(PolicyV1beta1RunAsGroupStrategyOptions item);
    
/**
 * This method has been deprecated, please use method buildRunAsUser instead.
 * @return The buildable object.
 */
@Deprecated public PolicyV1beta1RunAsUserStrategyOptions getRunAsUser();
    public PolicyV1beta1RunAsUserStrategyOptions buildRunAsUser();
    public A withRunAsUser(PolicyV1beta1RunAsUserStrategyOptions runAsUser);
    public Boolean hasRunAsUser();
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUser();
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUserLike(PolicyV1beta1RunAsUserStrategyOptions item);
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editRunAsUser();
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUser();
    public PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUserLike(PolicyV1beta1RunAsUserStrategyOptions item);
    
/**
 * This method has been deprecated, please use method buildSeLinux instead.
 * @return The buildable object.
 */
@Deprecated public PolicyV1beta1SELinuxStrategyOptions getSeLinux();
    public PolicyV1beta1SELinuxStrategyOptions buildSeLinux();
    public A withSeLinux(PolicyV1beta1SELinuxStrategyOptions seLinux);
    public Boolean hasSeLinux();
    public PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinux();
    public PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinuxLike(PolicyV1beta1SELinuxStrategyOptions item);
    public PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editSeLinux();
    public PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinux();
    public PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinuxLike(PolicyV1beta1SELinuxStrategyOptions item);
    
/**
 * This method has been deprecated, please use method buildSupplementalGroups instead.
 * @return The buildable object.
 */
@Deprecated public PolicyV1beta1SupplementalGroupsStrategyOptions getSupplementalGroups();
    public PolicyV1beta1SupplementalGroupsStrategyOptions buildSupplementalGroups();
    public A withSupplementalGroups(PolicyV1beta1SupplementalGroupsStrategyOptions supplementalGroups);
    public Boolean hasSupplementalGroups();
    public PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroups();
    public PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(PolicyV1beta1SupplementalGroupsStrategyOptions item);
    public PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editSupplementalGroups();
    public PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups();
    public PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(PolicyV1beta1SupplementalGroupsStrategyOptions item);
    public A addToVolumes(int index,String item);
    public A setToVolumes(int index,String item);
    public A addToVolumes(String... items);
    public A addAllToVolumes(Collection<String> items);
    public A removeFromVolumes(String... items);
    public A removeAllFromVolumes(Collection<String> items);
    public List<String> getVolumes();
    public String getVolume(int index);
    public String getFirstVolume();
    public String getLastVolume();
    public String getMatchingVolume(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingVolume(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withVolumes(List<String> volumes);
    public A withVolumes(String... volumes);
    public Boolean hasVolumes();
    public A addNewVolume(String arg1);
    public A addNewVolume(StringBuilder arg1);
    public A addNewVolume(StringBuffer arg1);

    public interface AllowedFlexVolumesNested<N> extends io.kubernetes.client.fluent.Nested<N>,PolicyV1beta1AllowedFlexVolumeFluent<PolicyV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>>{

        
    public N and();    public N endAllowedFlexVolume();
}
    public interface AllowedHostPathsNested<N> extends io.kubernetes.client.fluent.Nested<N>,PolicyV1beta1AllowedHostPathFluent<PolicyV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>>{

        
    public N and();    public N endAllowedHostPath();
}
    public interface FsGroupNested<N> extends io.kubernetes.client.fluent.Nested<N>,PolicyV1beta1FSGroupStrategyOptionsFluent<PolicyV1beta1PodSecurityPolicySpecFluent.FsGroupNested<N>>{

        
    public N and();    public N endFsGroup();
}
    public interface HostPortsNested<N> extends io.kubernetes.client.fluent.Nested<N>,PolicyV1beta1HostPortRangeFluent<PolicyV1beta1PodSecurityPolicySpecFluent.HostPortsNested<N>>{

        
    public N and();    public N endHostPort();
}
    public interface RunAsGroupNested<N> extends io.kubernetes.client.fluent.Nested<N>,PolicyV1beta1RunAsGroupStrategyOptionsFluent<PolicyV1beta1PodSecurityPolicySpecFluent.RunAsGroupNested<N>>{

        
    public N and();    public N endRunAsGroup();
}
    public interface RunAsUserNested<N> extends io.kubernetes.client.fluent.Nested<N>,PolicyV1beta1RunAsUserStrategyOptionsFluent<PolicyV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<N>>{

        
    public N and();    public N endRunAsUser();
}
    public interface SeLinuxNested<N> extends io.kubernetes.client.fluent.Nested<N>,PolicyV1beta1SELinuxStrategyOptionsFluent<PolicyV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<N>>{

        
    public N and();    public N endSeLinux();
}
    public interface SupplementalGroupsNested<N> extends io.kubernetes.client.fluent.Nested<N>,PolicyV1beta1SupplementalGroupsStrategyOptionsFluent<PolicyV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>>{

        
    public N and();    public N endSupplementalGroups();
}


}
