package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1APIResourceListFluent<A extends V1APIResourceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getGroupVersion();
    public A withGroupVersion(String groupVersion);
    public Boolean hasGroupVersion();
    public A withNewGroupVersion(String arg1);
    public A withNewGroupVersion(StringBuilder arg1);
    public A withNewGroupVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public A addToResources(int index,V1APIResource item);
    public A setToResources(int index,V1APIResource item);
    public A addToResources(V1APIResource... items);
    public A addAllToResources(Collection<V1APIResource> items);
    public A removeFromResources(V1APIResource... items);
    public A removeAllFromResources(Collection<V1APIResource> items);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<V1APIResource> getResources();
    public List<V1APIResource> buildResources();
    public V1APIResource buildResource(int index);
    public V1APIResource buildFirstResource();
    public V1APIResource buildLastResource();
    public V1APIResource buildMatchingResource(io.kubernetes.client.fluent.Predicate<V1APIResourceBuilder> predicate);
    public Boolean hasMatchingResource(io.kubernetes.client.fluent.Predicate<V1APIResourceBuilder> predicate);
    public A withResources(List<V1APIResource> resources);
    public A withResources(V1APIResource... resources);
    public Boolean hasResources();
    public V1APIResourceListFluent.ResourcesNested<A> addNewResource();
    public V1APIResourceListFluent.ResourcesNested<A> addNewResourceLike(V1APIResource item);
    public V1APIResourceListFluent.ResourcesNested<A> setNewResourceLike(int index,V1APIResource item);
    public V1APIResourceListFluent.ResourcesNested<A> editResource(int index);
    public V1APIResourceListFluent.ResourcesNested<A> editFirstResource();
    public V1APIResourceListFluent.ResourcesNested<A> editLastResource();
    public V1APIResourceListFluent.ResourcesNested<A> editMatchingResource(io.kubernetes.client.fluent.Predicate<V1APIResourceBuilder> predicate);

    public interface ResourcesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1APIResourceFluent<V1APIResourceListFluent.ResourcesNested<N>>{

        
    public N and();    public N endResource();
}


}
