package io.kubernetes.client.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1AzureFilePersistentVolumeSourceFluentImpl<A extends V1AzureFilePersistentVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1AzureFilePersistentVolumeSourceFluent<A>{

    private Boolean readOnly;
    private String secretName;
    private String secretNamespace;
    private String shareName;

    public V1AzureFilePersistentVolumeSourceFluentImpl(){
    }
    public V1AzureFilePersistentVolumeSourceFluentImpl(V1AzureFilePersistentVolumeSource instance){
            this.withReadOnly(instance.isReadOnly());

            this.withSecretName(instance.getSecretName());

            this.withSecretNamespace(instance.getSecretNamespace());

            this.withShareName(instance.getShareName());

    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public String getSecretName(){
            return this.secretName;
    }

    public A withSecretName(String secretName){
            this.secretName=secretName; return (A) this;
    }

    public Boolean hasSecretName(){
            return this.secretName != null;
    }

    public A withNewSecretName(String arg1){
            return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuilder arg1){
            return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuffer arg1){
            return (A)withSecretName(new String(arg1));
    }

    public String getSecretNamespace(){
            return this.secretNamespace;
    }

    public A withSecretNamespace(String secretNamespace){
            this.secretNamespace=secretNamespace; return (A) this;
    }

    public Boolean hasSecretNamespace(){
            return this.secretNamespace != null;
    }

    public A withNewSecretNamespace(String arg1){
            return (A)withSecretNamespace(new String(arg1));
    }

    public A withNewSecretNamespace(StringBuilder arg1){
            return (A)withSecretNamespace(new String(arg1));
    }

    public A withNewSecretNamespace(StringBuffer arg1){
            return (A)withSecretNamespace(new String(arg1));
    }

    public String getShareName(){
            return this.shareName;
    }

    public A withShareName(String shareName){
            this.shareName=shareName; return (A) this;
    }

    public Boolean hasShareName(){
            return this.shareName != null;
    }

    public A withNewShareName(String arg1){
            return (A)withShareName(new String(arg1));
    }

    public A withNewShareName(StringBuilder arg1){
            return (A)withShareName(new String(arg1));
    }

    public A withNewShareName(StringBuffer arg1){
            return (A)withShareName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1AzureFilePersistentVolumeSourceFluentImpl that = (V1AzureFilePersistentVolumeSourceFluentImpl) o;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
            if (secretNamespace != null ? !secretNamespace.equals(that.secretNamespace) :that.secretNamespace != null) return false;
            if (shareName != null ? !shareName.equals(that.shareName) :that.shareName != null) return false;
            return true;
    }




}
