package io.kubernetes.client.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1ConfigMapNodeConfigSourceFluentImpl<A extends V1ConfigMapNodeConfigSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ConfigMapNodeConfigSourceFluent<A>{

    private String kubeletConfigKey;
    private String name;
    private String namespace;
    private String resourceVersion;
    private String uid;

    public V1ConfigMapNodeConfigSourceFluentImpl(){
    }
    public V1ConfigMapNodeConfigSourceFluentImpl(V1ConfigMapNodeConfigSource instance){
            this.withKubeletConfigKey(instance.getKubeletConfigKey());

            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.withResourceVersion(instance.getResourceVersion());

            this.withUid(instance.getUid());

    }

    public String getKubeletConfigKey(){
            return this.kubeletConfigKey;
    }

    public A withKubeletConfigKey(String kubeletConfigKey){
            this.kubeletConfigKey=kubeletConfigKey; return (A) this;
    }

    public Boolean hasKubeletConfigKey(){
            return this.kubeletConfigKey != null;
    }

    public A withNewKubeletConfigKey(String arg1){
            return (A)withKubeletConfigKey(new String(arg1));
    }

    public A withNewKubeletConfigKey(StringBuilder arg1){
            return (A)withKubeletConfigKey(new String(arg1));
    }

    public A withNewKubeletConfigKey(StringBuffer arg1){
            return (A)withKubeletConfigKey(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getNamespace(){
            return this.namespace;
    }

    public A withNamespace(String namespace){
            this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace(){
            return this.namespace != null;
    }

    public A withNewNamespace(String arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1){
            return (A)withNamespace(new String(arg1));
    }

    public String getResourceVersion(){
            return this.resourceVersion;
    }

    public A withResourceVersion(String resourceVersion){
            this.resourceVersion=resourceVersion; return (A) this;
    }

    public Boolean hasResourceVersion(){
            return this.resourceVersion != null;
    }

    public A withNewResourceVersion(String arg1){
            return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuilder arg1){
            return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuffer arg1){
            return (A)withResourceVersion(new String(arg1));
    }

    public String getUid(){
            return this.uid;
    }

    public A withUid(String uid){
            this.uid=uid; return (A) this;
    }

    public Boolean hasUid(){
            return this.uid != null;
    }

    public A withNewUid(String arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuilder arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1){
            return (A)withUid(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ConfigMapNodeConfigSourceFluentImpl that = (V1ConfigMapNodeConfigSourceFluentImpl) o;
            if (kubeletConfigKey != null ? !kubeletConfigKey.equals(that.kubeletConfigKey) :that.kubeletConfigKey != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
            if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
            if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
            return true;
    }




}
