package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface V1EndpointAddressFluent<A extends V1EndpointAddressFluent<A>> extends Fluent<A>{


    public String getHostname();
    public A withHostname(String hostname);
    public Boolean hasHostname();
    public A withNewHostname(String arg1);
    public A withNewHostname(StringBuilder arg1);
    public A withNewHostname(StringBuffer arg1);
    public String getIp();
    public A withIp(String ip);
    public Boolean hasIp();
    public A withNewIp(String arg1);
    public A withNewIp(StringBuilder arg1);
    public A withNewIp(StringBuffer arg1);
    public String getNodeName();
    public A withNodeName(String nodeName);
    public Boolean hasNodeName();
    public A withNewNodeName(String arg1);
    public A withNewNodeName(StringBuilder arg1);
    public A withNewNodeName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTargetRef instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getTargetRef();
    public V1ObjectReference buildTargetRef();
    public A withTargetRef(V1ObjectReference targetRef);
    public Boolean hasTargetRef();
    public V1EndpointAddressFluent.TargetRefNested<A> withNewTargetRef();
    public V1EndpointAddressFluent.TargetRefNested<A> withNewTargetRefLike(V1ObjectReference item);
    public V1EndpointAddressFluent.TargetRefNested<A> editTargetRef();
    public V1EndpointAddressFluent.TargetRefNested<A> editOrNewTargetRef();
    public V1EndpointAddressFluent.TargetRefNested<A> editOrNewTargetRefLike(V1ObjectReference item);

    public interface TargetRefNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectReferenceFluent<V1EndpointAddressFluent.TargetRefNested<N>>{

        
    public N and();    public N endTargetRef();
}


}
