package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1EndpointsListFluent<A extends V1EndpointsListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,V1Endpoints item);
    public A setToItems(int index,V1Endpoints item);
    public A addToItems(V1Endpoints... items);
    public A addAllToItems(Collection<V1Endpoints> items);
    public A removeFromItems(V1Endpoints... items);
    public A removeAllFromItems(Collection<V1Endpoints> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Endpoints> getItems();
    public List<V1Endpoints> buildItems();
    public V1Endpoints buildItem(int index);
    public V1Endpoints buildFirstItem();
    public V1Endpoints buildLastItem();
    public V1Endpoints buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1EndpointsBuilder> predicate);
    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1EndpointsBuilder> predicate);
    public A withItems(List<V1Endpoints> items);
    public A withItems(V1Endpoints... items);
    public Boolean hasItems();
    public V1EndpointsListFluent.ItemsNested<A> addNewItem();
    public V1EndpointsListFluent.ItemsNested<A> addNewItemLike(V1Endpoints item);
    public V1EndpointsListFluent.ItemsNested<A> setNewItemLike(int index,V1Endpoints item);
    public V1EndpointsListFluent.ItemsNested<A> editItem(int index);
    public V1EndpointsListFluent.ItemsNested<A> editFirstItem();
    public V1EndpointsListFluent.ItemsNested<A> editLastItem();
    public V1EndpointsListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1EndpointsBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata();
    public V1ListMeta buildMetadata();
    public A withMetadata(V1ListMeta metadata);
    public Boolean hasMetadata();
    public V1EndpointsListFluent.MetadataNested<A> withNewMetadata();
    public V1EndpointsListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item);
    public V1EndpointsListFluent.MetadataNested<A> editMetadata();
    public V1EndpointsListFluent.MetadataNested<A> editOrNewMetadata();
    public V1EndpointsListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item);

    public interface ItemsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1EndpointsFluent<V1EndpointsListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ListMetaFluent<V1EndpointsListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
