package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1GlusterfsVolumeSourceBuilder extends V1GlusterfsVolumeSourceFluentImpl<V1GlusterfsVolumeSourceBuilder> implements VisitableBuilder<V1GlusterfsVolumeSource,V1GlusterfsVolumeSourceBuilder>{

    V1GlusterfsVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1GlusterfsVolumeSourceBuilder(){
            this(true);
    }
    public V1GlusterfsVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1GlusterfsVolumeSource(), validationEnabled);
    }
    public V1GlusterfsVolumeSourceBuilder(V1GlusterfsVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1GlusterfsVolumeSourceBuilder(V1GlusterfsVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1GlusterfsVolumeSource(), validationEnabled);
    }
    public V1GlusterfsVolumeSourceBuilder(V1GlusterfsVolumeSourceFluent<?> fluent,V1GlusterfsVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1GlusterfsVolumeSourceBuilder(V1GlusterfsVolumeSourceFluent<?> fluent,V1GlusterfsVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEndpoints(instance.getEndpoints());

            fluent.withPath(instance.getPath());

            fluent.withReadOnly(instance.isReadOnly());

            this.validationEnabled = validationEnabled; 
    }
    public V1GlusterfsVolumeSourceBuilder(V1GlusterfsVolumeSource instance){
            this(instance,true);
    }
    public V1GlusterfsVolumeSourceBuilder(V1GlusterfsVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEndpoints(instance.getEndpoints());

            this.withPath(instance.getPath());

            this.withReadOnly(instance.isReadOnly());

            this.validationEnabled = validationEnabled; 
    }

    public V1GlusterfsVolumeSource build(){
            V1GlusterfsVolumeSource buildable = new V1GlusterfsVolumeSource();
            buildable.setEndpoints(fluent.getEndpoints());
            buildable.setPath(fluent.getPath());
            buildable.setReadOnly(fluent.isReadOnly());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1GlusterfsVolumeSourceBuilder that = (V1GlusterfsVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
