package io.kubernetes.client.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1HTTPHeaderFluentImpl<A extends V1HTTPHeaderFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1HTTPHeaderFluent<A>{

    private String name;
    private String value;

    public V1HTTPHeaderFluentImpl(){
    }
    public V1HTTPHeaderFluentImpl(V1HTTPHeader instance){
            this.withName(instance.getName());

            this.withValue(instance.getValue());

    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getValue(){
            return this.value;
    }

    public A withValue(String value){
            this.value=value; return (A) this;
    }

    public Boolean hasValue(){
            return this.value != null;
    }

    public A withNewValue(String arg1){
            return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuilder arg1){
            return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1){
            return (A)withValue(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1HTTPHeaderFluentImpl that = (V1HTTPHeaderFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }




}
