package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1HandlerFluentImpl<A extends V1HandlerFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1HandlerFluent<A>{

    private V1ExecActionBuilder exec;
    private V1HTTPGetActionBuilder httpGet;
    private V1TCPSocketActionBuilder tcpSocket;

    public V1HandlerFluentImpl(){
    }
    public V1HandlerFluentImpl(V1Handler instance){
            this.withExec(instance.getExec());

            this.withHttpGet(instance.getHttpGet());

            this.withTcpSocket(instance.getTcpSocket());

    }

    
/**
 * This method has been deprecated, please use method buildExec instead.
 * @return The buildable object.
 */
@Deprecated public V1ExecAction getExec(){
            return this.exec!=null?this.exec.build():null;
    }

    public V1ExecAction buildExec(){
            return this.exec!=null?this.exec.build():null;
    }

    public A withExec(V1ExecAction exec){
            _visitables.get("exec").remove(this.exec);
            if (exec!=null){ this.exec= new V1ExecActionBuilder(exec); _visitables.get("exec").add(this.exec);} return (A) this;
    }

    public Boolean hasExec(){
            return this.exec != null;
    }

    public V1HandlerFluent.ExecNested<A> withNewExec(){
            return new ExecNestedImpl();
    }

    public V1HandlerFluent.ExecNested<A> withNewExecLike(V1ExecAction item){
            return new ExecNestedImpl(item);
    }

    public V1HandlerFluent.ExecNested<A> editExec(){
            return withNewExecLike(getExec());
    }

    public V1HandlerFluent.ExecNested<A> editOrNewExec(){
            return withNewExecLike(getExec() != null ? getExec(): new V1ExecActionBuilder().build());
    }

    public V1HandlerFluent.ExecNested<A> editOrNewExecLike(V1ExecAction item){
            return withNewExecLike(getExec() != null ? getExec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildHttpGet instead.
 * @return The buildable object.
 */
@Deprecated public V1HTTPGetAction getHttpGet(){
            return this.httpGet!=null?this.httpGet.build():null;
    }

    public V1HTTPGetAction buildHttpGet(){
            return this.httpGet!=null?this.httpGet.build():null;
    }

    public A withHttpGet(V1HTTPGetAction httpGet){
            _visitables.get("httpGet").remove(this.httpGet);
            if (httpGet!=null){ this.httpGet= new V1HTTPGetActionBuilder(httpGet); _visitables.get("httpGet").add(this.httpGet);} return (A) this;
    }

    public Boolean hasHttpGet(){
            return this.httpGet != null;
    }

    public V1HandlerFluent.HttpGetNested<A> withNewHttpGet(){
            return new HttpGetNestedImpl();
    }

    public V1HandlerFluent.HttpGetNested<A> withNewHttpGetLike(V1HTTPGetAction item){
            return new HttpGetNestedImpl(item);
    }

    public V1HandlerFluent.HttpGetNested<A> editHttpGet(){
            return withNewHttpGetLike(getHttpGet());
    }

    public V1HandlerFluent.HttpGetNested<A> editOrNewHttpGet(){
            return withNewHttpGetLike(getHttpGet() != null ? getHttpGet(): new V1HTTPGetActionBuilder().build());
    }

    public V1HandlerFluent.HttpGetNested<A> editOrNewHttpGetLike(V1HTTPGetAction item){
            return withNewHttpGetLike(getHttpGet() != null ? getHttpGet(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTcpSocket instead.
 * @return The buildable object.
 */
@Deprecated public V1TCPSocketAction getTcpSocket(){
            return this.tcpSocket!=null?this.tcpSocket.build():null;
    }

    public V1TCPSocketAction buildTcpSocket(){
            return this.tcpSocket!=null?this.tcpSocket.build():null;
    }

    public A withTcpSocket(V1TCPSocketAction tcpSocket){
            _visitables.get("tcpSocket").remove(this.tcpSocket);
            if (tcpSocket!=null){ this.tcpSocket= new V1TCPSocketActionBuilder(tcpSocket); _visitables.get("tcpSocket").add(this.tcpSocket);} return (A) this;
    }

    public Boolean hasTcpSocket(){
            return this.tcpSocket != null;
    }

    public V1HandlerFluent.TcpSocketNested<A> withNewTcpSocket(){
            return new TcpSocketNestedImpl();
    }

    public V1HandlerFluent.TcpSocketNested<A> withNewTcpSocketLike(V1TCPSocketAction item){
            return new TcpSocketNestedImpl(item);
    }

    public V1HandlerFluent.TcpSocketNested<A> editTcpSocket(){
            return withNewTcpSocketLike(getTcpSocket());
    }

    public V1HandlerFluent.TcpSocketNested<A> editOrNewTcpSocket(){
            return withNewTcpSocketLike(getTcpSocket() != null ? getTcpSocket(): new V1TCPSocketActionBuilder().build());
    }

    public V1HandlerFluent.TcpSocketNested<A> editOrNewTcpSocketLike(V1TCPSocketAction item){
            return withNewTcpSocketLike(getTcpSocket() != null ? getTcpSocket(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1HandlerFluentImpl that = (V1HandlerFluentImpl) o;
            if (exec != null ? !exec.equals(that.exec) :that.exec != null) return false;
            if (httpGet != null ? !httpGet.equals(that.httpGet) :that.httpGet != null) return false;
            if (tcpSocket != null ? !tcpSocket.equals(that.tcpSocket) :that.tcpSocket != null) return false;
            return true;
    }


    public class ExecNestedImpl<N> extends V1ExecActionFluentImpl<V1HandlerFluent.ExecNested<N>> implements V1HandlerFluent.ExecNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ExecActionBuilder builder;
    
            ExecNestedImpl(V1ExecAction item){
                    this.builder = new V1ExecActionBuilder(this, item);
            }
            ExecNestedImpl(){
                    this.builder = new V1ExecActionBuilder(this);
            }
    
    public N and(){
            return (N) V1HandlerFluentImpl.this.withExec(builder.build());
    }
    public N endExec(){
            return and();
    }

}
    public class HttpGetNestedImpl<N> extends V1HTTPGetActionFluentImpl<V1HandlerFluent.HttpGetNested<N>> implements V1HandlerFluent.HttpGetNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1HTTPGetActionBuilder builder;
    
            HttpGetNestedImpl(V1HTTPGetAction item){
                    this.builder = new V1HTTPGetActionBuilder(this, item);
            }
            HttpGetNestedImpl(){
                    this.builder = new V1HTTPGetActionBuilder(this);
            }
    
    public N and(){
            return (N) V1HandlerFluentImpl.this.withHttpGet(builder.build());
    }
    public N endHttpGet(){
            return and();
    }

}
    public class TcpSocketNestedImpl<N> extends V1TCPSocketActionFluentImpl<V1HandlerFluent.TcpSocketNested<N>> implements V1HandlerFluent.TcpSocketNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1TCPSocketActionBuilder builder;
    
            TcpSocketNestedImpl(V1TCPSocketAction item){
                    this.builder = new V1TCPSocketActionBuilder(this, item);
            }
            TcpSocketNestedImpl(){
                    this.builder = new V1TCPSocketActionBuilder(this);
            }
    
    public N and(){
            return (N) V1HandlerFluentImpl.this.withTcpSocket(builder.build());
    }
    public N endTcpSocket(){
            return and();
    }

}


}
