package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1IPBlockFluentImpl<A extends V1IPBlockFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1IPBlockFluent<A>{

    private String cidr;
    private List<String> except;

    public V1IPBlockFluentImpl(){
    }
    public V1IPBlockFluentImpl(V1IPBlock instance){
            this.withCidr(instance.getCidr());

            this.withExcept(instance.getExcept());

    }

    public String getCidr(){
            return this.cidr;
    }

    public A withCidr(String cidr){
            this.cidr=cidr; return (A) this;
    }

    public Boolean hasCidr(){
            return this.cidr != null;
    }

    public A withNewCidr(String arg1){
            return (A)withCidr(new String(arg1));
    }

    public A withNewCidr(StringBuilder arg1){
            return (A)withCidr(new String(arg1));
    }

    public A withNewCidr(StringBuffer arg1){
            return (A)withCidr(new String(arg1));
    }

    public A addToExcept(int index,String item){
            if (this.except == null) {this.except = new ArrayList<String>();}
            this.except.add(index, item);
            return (A)this;
    }

    public A setToExcept(int index,String item){
            if (this.except == null) {this.except = new ArrayList<String>();}
            this.except.set(index, item); return (A)this;
    }

    public A addToExcept(String... items){
            if (this.except == null) {this.except = new ArrayList<String>();}
            for (String item : items) {this.except.add(item);} return (A)this;
    }

    public A addAllToExcept(Collection<String> items){
            if (this.except == null) {this.except = new ArrayList<String>();}
            for (String item : items) {this.except.add(item);} return (A)this;
    }

    public A removeFromExcept(String... items){
            for (String item : items) {if (this.except!= null){ this.except.remove(item);}} return (A)this;
    }

    public A removeAllFromExcept(Collection<String> items){
            for (String item : items) {if (this.except!= null){ this.except.remove(item);}} return (A)this;
    }

    public List<String> getExcept(){
            return this.except;
    }

    public String getExcept(int index){
            return this.except.get(index);
    }

    public String getFirstExcept(){
            return this.except.get(0);
    }

    public String getLastExcept(){
            return this.except.get(except.size() - 1);
    }

    public String getMatchingExcept(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: except) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingExcept(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: except) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withExcept(List<String> except){
            if (this.except != null) { _visitables.get("except").removeAll(this.except);}
            if (except != null) {this.except = new ArrayList<String>(); for (String item : except){this.addToExcept(item);}} else { this.except = null;} return (A) this;
    }

    public A withExcept(String... except){
            if (this.except != null) {this.except.clear();}
            if (except != null) {for (String item :except){ this.addToExcept(item);}} return (A) this;
    }

    public Boolean hasExcept(){
            return except != null && !except.isEmpty();
    }

    public A addNewExcept(String arg1){
            return (A)addToExcept(new String(arg1));
    }

    public A addNewExcept(StringBuilder arg1){
            return (A)addToExcept(new String(arg1));
    }

    public A addNewExcept(StringBuffer arg1){
            return (A)addToExcept(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1IPBlockFluentImpl that = (V1IPBlockFluentImpl) o;
            if (cidr != null ? !cidr.equals(that.cidr) :that.cidr != null) return false;
            if (except != null ? !except.equals(that.except) :that.except != null) return false;
            return true;
    }




}
