package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1InitializersBuilder extends V1InitializersFluentImpl<V1InitializersBuilder> implements VisitableBuilder<V1Initializers,V1InitializersBuilder>{

    V1InitializersFluent<?> fluent;
    Boolean validationEnabled;

    public V1InitializersBuilder(){
            this(true);
    }
    public V1InitializersBuilder(Boolean validationEnabled){
            this(new V1Initializers(), validationEnabled);
    }
    public V1InitializersBuilder(V1InitializersFluent<?> fluent){
            this(fluent, true);
    }
    public V1InitializersBuilder(V1InitializersFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1Initializers(), validationEnabled);
    }
    public V1InitializersBuilder(V1InitializersFluent<?> fluent,V1Initializers instance){
            this(fluent, instance, true);
    }
    public V1InitializersBuilder(V1InitializersFluent<?> fluent,V1Initializers instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPending(instance.getPending());

            fluent.withResult(instance.getResult());

            this.validationEnabled = validationEnabled; 
    }
    public V1InitializersBuilder(V1Initializers instance){
            this(instance,true);
    }
    public V1InitializersBuilder(V1Initializers instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPending(instance.getPending());

            this.withResult(instance.getResult());

            this.validationEnabled = validationEnabled; 
    }

    public V1Initializers build(){
            V1Initializers buildable = new V1Initializers();
            buildable.setPending(fluent.getPending());
            buildable.setResult(fluent.getResult());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1InitializersBuilder that = (V1InitializersBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
