package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import org.joda.time.DateTime;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public interface V1JobStatusFluent<A extends V1JobStatusFluent<A>> extends Fluent<A>{


    public Integer getActive();
    public A withActive(Integer active);
    public Boolean hasActive();
    public DateTime getCompletionTime();
    public A withCompletionTime(DateTime completionTime);
    public Boolean hasCompletionTime();
    public A withNewCompletionTime(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewCompletionTime(Object arg0);
    public A withNewCompletionTime(long arg0);
    public A addToConditions(int index,V1JobCondition item);
    public A setToConditions(int index,V1JobCondition item);
    public A addToConditions(V1JobCondition... items);
    public A addAllToConditions(Collection<V1JobCondition> items);
    public A removeFromConditions(V1JobCondition... items);
    public A removeAllFromConditions(Collection<V1JobCondition> items);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1JobCondition> getConditions();
    public List<V1JobCondition> buildConditions();
    public V1JobCondition buildCondition(int index);
    public V1JobCondition buildFirstCondition();
    public V1JobCondition buildLastCondition();
    public V1JobCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1JobConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1JobConditionBuilder> predicate);
    public A withConditions(List<V1JobCondition> conditions);
    public A withConditions(V1JobCondition... conditions);
    public Boolean hasConditions();
    public V1JobStatusFluent.ConditionsNested<A> addNewCondition();
    public V1JobStatusFluent.ConditionsNested<A> addNewConditionLike(V1JobCondition item);
    public V1JobStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1JobCondition item);
    public V1JobStatusFluent.ConditionsNested<A> editCondition(int index);
    public V1JobStatusFluent.ConditionsNested<A> editFirstCondition();
    public V1JobStatusFluent.ConditionsNested<A> editLastCondition();
    public V1JobStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1JobConditionBuilder> predicate);
    public Integer getFailed();
    public A withFailed(Integer failed);
    public Boolean hasFailed();
    public DateTime getStartTime();
    public A withStartTime(DateTime startTime);
    public Boolean hasStartTime();
    public A withNewStartTime(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewStartTime(Object arg0);
    public A withNewStartTime(long arg0);
    public Integer getSucceeded();
    public A withSucceeded(Integer succeeded);
    public Boolean hasSucceeded();

    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1JobConditionFluent<V1JobStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}


}
