package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class V1LabelSelectorFluentImpl<A extends V1LabelSelectorFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1LabelSelectorFluent<A>{

    private List<V1LabelSelectorRequirementBuilder> matchExpressions;
    private Map<String,String> matchLabels;

    public V1LabelSelectorFluentImpl(){
    }
    public V1LabelSelectorFluentImpl(V1LabelSelector instance){
            this.withMatchExpressions(instance.getMatchExpressions());

            this.withMatchLabels(instance.getMatchLabels());

    }

    public A addToMatchExpressions(int index,V1LabelSelectorRequirement item){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1LabelSelectorRequirementBuilder>();}
            V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(index >= 0 ? index : _visitables.get("matchExpressions").size(), builder);this.matchExpressions.add(index >= 0 ? index : matchExpressions.size(), builder); return (A)this;
    }

    public A setToMatchExpressions(int index,V1LabelSelectorRequirement item){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1LabelSelectorRequirementBuilder>();}
            V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);
            if (index < 0 || index >= _visitables.get("matchExpressions").size()) { _visitables.get("matchExpressions").add(builder); } else { _visitables.get("matchExpressions").set(index, builder);}
            if (index < 0 || index >= matchExpressions.size()) { matchExpressions.add(builder); } else { matchExpressions.set(index, builder);}
             return (A)this;
    }

    public A addToMatchExpressions(V1LabelSelectorRequirement... items){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1LabelSelectorRequirementBuilder>();}
            for (V1LabelSelectorRequirement item : items) {V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
    }

    public A addAllToMatchExpressions(Collection<V1LabelSelectorRequirement> items){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1LabelSelectorRequirementBuilder>();}
            for (V1LabelSelectorRequirement item : items) {V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
    }

    public A removeFromMatchExpressions(V1LabelSelectorRequirement... items){
            for (V1LabelSelectorRequirement item : items) {V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
    }

    public A removeAllFromMatchExpressions(Collection<V1LabelSelectorRequirement> items){
            for (V1LabelSelectorRequirement item : items) {V1LabelSelectorRequirementBuilder builder = new V1LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMatchExpressions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1LabelSelectorRequirement> getMatchExpressions(){
            return build(matchExpressions);
    }

    public List<V1LabelSelectorRequirement> buildMatchExpressions(){
            return build(matchExpressions);
    }

    public V1LabelSelectorRequirement buildMatchExpression(int index){
            return this.matchExpressions.get(index).build();
    }

    public V1LabelSelectorRequirement buildFirstMatchExpression(){
            return this.matchExpressions.get(0).build();
    }

    public V1LabelSelectorRequirement buildLastMatchExpression(){
            return this.matchExpressions.get(matchExpressions.size() - 1).build();
    }

    public V1LabelSelectorRequirement buildMatchingMatchExpression(io.kubernetes.client.fluent.Predicate<V1LabelSelectorRequirementBuilder> predicate){
            for (V1LabelSelectorRequirementBuilder item: matchExpressions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingMatchExpression(io.kubernetes.client.fluent.Predicate<V1LabelSelectorRequirementBuilder> predicate){
            for (V1LabelSelectorRequirementBuilder item: matchExpressions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withMatchExpressions(List<V1LabelSelectorRequirement> matchExpressions){
            if (this.matchExpressions != null) { _visitables.get("matchExpressions").removeAll(this.matchExpressions);}
            if (matchExpressions != null) {this.matchExpressions = new ArrayList<V1LabelSelectorRequirementBuilder>(); for (V1LabelSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} else { this.matchExpressions = null;} return (A) this;
    }

    public A withMatchExpressions(V1LabelSelectorRequirement... matchExpressions){
            if (this.matchExpressions != null) {this.matchExpressions.clear();}
            if (matchExpressions != null) {for (V1LabelSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (A) this;
    }

    public Boolean hasMatchExpressions(){
            return matchExpressions != null && !matchExpressions.isEmpty();
    }

    public V1LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpression(){
            return new MatchExpressionsNestedImpl();
    }

    public V1LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(V1LabelSelectorRequirement item){
            return new MatchExpressionsNestedImpl(-1, item);
    }

    public V1LabelSelectorFluent.MatchExpressionsNested<A> setNewMatchExpressionLike(int index,V1LabelSelectorRequirement item){
            return new MatchExpressionsNestedImpl(index, item);
    }

    public V1LabelSelectorFluent.MatchExpressionsNested<A> editMatchExpression(int index){
            if (matchExpressions.size() <= index) throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
            return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public V1LabelSelectorFluent.MatchExpressionsNested<A> editFirstMatchExpression(){
            if (matchExpressions.size() == 0) throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
            return setNewMatchExpressionLike(0, buildMatchExpression(0));
    }

    public V1LabelSelectorFluent.MatchExpressionsNested<A> editLastMatchExpression(){
            int index = matchExpressions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
            return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public V1LabelSelectorFluent.MatchExpressionsNested<A> editMatchingMatchExpression(io.kubernetes.client.fluent.Predicate<V1LabelSelectorRequirementBuilder> predicate){
            int index = -1;
            for (int i=0;i<matchExpressions.size();i++) { 
            if (predicate.apply(matchExpressions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
            return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public A addToMatchLabels(String key,String value){
            if(this.matchLabels == null && key != null && value != null) { this.matchLabels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.matchLabels.put(key, value);} return (A)this;
    }

    public A addToMatchLabels(Map<String,String> map){
            if(this.matchLabels == null && map != null) { this.matchLabels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.matchLabels.putAll(map);} return (A)this;
    }

    public A removeFromMatchLabels(String key){
            if(this.matchLabels == null) { return (A) this; }
            if(key != null && this.matchLabels != null) {this.matchLabels.remove(key);} return (A)this;
    }

    public A removeFromMatchLabels(Map<String,String> map){
            if(this.matchLabels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.matchLabels != null){this.matchLabels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getMatchLabels(){
            return this.matchLabels;
    }

    public A withMatchLabels(Map<String,String> matchLabels){
            if (matchLabels == null) { this.matchLabels =  null;} else {this.matchLabels = new LinkedHashMap<String,String>(matchLabels);} return (A) this;
    }

    public Boolean hasMatchLabels(){
            return this.matchLabels != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1LabelSelectorFluentImpl that = (V1LabelSelectorFluentImpl) o;
            if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
            if (matchLabels != null ? !matchLabels.equals(that.matchLabels) :that.matchLabels != null) return false;
            return true;
    }


    public class MatchExpressionsNestedImpl<N> extends V1LabelSelectorRequirementFluentImpl<V1LabelSelectorFluent.MatchExpressionsNested<N>> implements V1LabelSelectorFluent.MatchExpressionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorRequirementBuilder builder;
        private final int index;
    
            MatchExpressionsNestedImpl(int index,V1LabelSelectorRequirement item){
                    this.index = index;
                    this.builder = new V1LabelSelectorRequirementBuilder(this, item);
            }
            MatchExpressionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1LabelSelectorRequirementBuilder(this);
            }
    
    public N and(){
            return (N) V1LabelSelectorFluentImpl.this.setToMatchExpressions(index, builder.build());
    }
    public N endMatchExpression(){
            return and();
    }

}


}
