package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1LimitRangeSpecFluentImpl<A extends V1LimitRangeSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1LimitRangeSpecFluent<A>{

    private List<V1LimitRangeItemBuilder> limits;

    public V1LimitRangeSpecFluentImpl(){
    }
    public V1LimitRangeSpecFluentImpl(V1LimitRangeSpec instance){
            this.withLimits(instance.getLimits());

    }

    public A addToLimits(int index,V1LimitRangeItem item){
            if (this.limits == null) {this.limits = new ArrayList<V1LimitRangeItemBuilder>();}
            V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);_visitables.get("limits").add(index >= 0 ? index : _visitables.get("limits").size(), builder);this.limits.add(index >= 0 ? index : limits.size(), builder); return (A)this;
    }

    public A setToLimits(int index,V1LimitRangeItem item){
            if (this.limits == null) {this.limits = new ArrayList<V1LimitRangeItemBuilder>();}
            V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);
            if (index < 0 || index >= _visitables.get("limits").size()) { _visitables.get("limits").add(builder); } else { _visitables.get("limits").set(index, builder);}
            if (index < 0 || index >= limits.size()) { limits.add(builder); } else { limits.set(index, builder);}
             return (A)this;
    }

    public A addToLimits(V1LimitRangeItem... items){
            if (this.limits == null) {this.limits = new ArrayList<V1LimitRangeItemBuilder>();}
            for (V1LimitRangeItem item : items) {V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);_visitables.get("limits").add(builder);this.limits.add(builder);} return (A)this;
    }

    public A addAllToLimits(Collection<V1LimitRangeItem> items){
            if (this.limits == null) {this.limits = new ArrayList<V1LimitRangeItemBuilder>();}
            for (V1LimitRangeItem item : items) {V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);_visitables.get("limits").add(builder);this.limits.add(builder);} return (A)this;
    }

    public A removeFromLimits(V1LimitRangeItem... items){
            for (V1LimitRangeItem item : items) {V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);_visitables.get("limits").remove(builder);if (this.limits != null) {this.limits.remove(builder);}} return (A)this;
    }

    public A removeAllFromLimits(Collection<V1LimitRangeItem> items){
            for (V1LimitRangeItem item : items) {V1LimitRangeItemBuilder builder = new V1LimitRangeItemBuilder(item);_visitables.get("limits").remove(builder);if (this.limits != null) {this.limits.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildLimits instead.
 * @return The buildable object.
 */
@Deprecated public List<V1LimitRangeItem> getLimits(){
            return build(limits);
    }

    public List<V1LimitRangeItem> buildLimits(){
            return build(limits);
    }

    public V1LimitRangeItem buildLimit(int index){
            return this.limits.get(index).build();
    }

    public V1LimitRangeItem buildFirstLimit(){
            return this.limits.get(0).build();
    }

    public V1LimitRangeItem buildLastLimit(){
            return this.limits.get(limits.size() - 1).build();
    }

    public V1LimitRangeItem buildMatchingLimit(io.kubernetes.client.fluent.Predicate<V1LimitRangeItemBuilder> predicate){
            for (V1LimitRangeItemBuilder item: limits) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingLimit(io.kubernetes.client.fluent.Predicate<V1LimitRangeItemBuilder> predicate){
            for (V1LimitRangeItemBuilder item: limits) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withLimits(List<V1LimitRangeItem> limits){
            if (this.limits != null) { _visitables.get("limits").removeAll(this.limits);}
            if (limits != null) {this.limits = new ArrayList<V1LimitRangeItemBuilder>(); for (V1LimitRangeItem item : limits){this.addToLimits(item);}} else { this.limits = null;} return (A) this;
    }

    public A withLimits(V1LimitRangeItem... limits){
            if (this.limits != null) {this.limits.clear();}
            if (limits != null) {for (V1LimitRangeItem item :limits){ this.addToLimits(item);}} return (A) this;
    }

    public Boolean hasLimits(){
            return limits != null && !limits.isEmpty();
    }

    public V1LimitRangeSpecFluent.LimitsNested<A> addNewLimit(){
            return new LimitsNestedImpl();
    }

    public V1LimitRangeSpecFluent.LimitsNested<A> addNewLimitLike(V1LimitRangeItem item){
            return new LimitsNestedImpl(-1, item);
    }

    public V1LimitRangeSpecFluent.LimitsNested<A> setNewLimitLike(int index,V1LimitRangeItem item){
            return new LimitsNestedImpl(index, item);
    }

    public V1LimitRangeSpecFluent.LimitsNested<A> editLimit(int index){
            if (limits.size() <= index) throw new RuntimeException("Can't edit limits. Index exceeds size.");
            return setNewLimitLike(index, buildLimit(index));
    }

    public V1LimitRangeSpecFluent.LimitsNested<A> editFirstLimit(){
            if (limits.size() == 0) throw new RuntimeException("Can't edit first limits. The list is empty.");
            return setNewLimitLike(0, buildLimit(0));
    }

    public V1LimitRangeSpecFluent.LimitsNested<A> editLastLimit(){
            int index = limits.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last limits. The list is empty.");
            return setNewLimitLike(index, buildLimit(index));
    }

    public V1LimitRangeSpecFluent.LimitsNested<A> editMatchingLimit(io.kubernetes.client.fluent.Predicate<V1LimitRangeItemBuilder> predicate){
            int index = -1;
            for (int i=0;i<limits.size();i++) { 
            if (predicate.apply(limits.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching limits. No match found.");
            return setNewLimitLike(index, buildLimit(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1LimitRangeSpecFluentImpl that = (V1LimitRangeSpecFluentImpl) o;
            if (limits != null ? !limits.equals(that.limits) :that.limits != null) return false;
            return true;
    }


    public class LimitsNestedImpl<N> extends V1LimitRangeItemFluentImpl<V1LimitRangeSpecFluent.LimitsNested<N>> implements V1LimitRangeSpecFluent.LimitsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LimitRangeItemBuilder builder;
        private final int index;
    
            LimitsNestedImpl(int index,V1LimitRangeItem item){
                    this.index = index;
                    this.builder = new V1LimitRangeItemBuilder(this, item);
            }
            LimitsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1LimitRangeItemBuilder(this);
            }
    
    public N and(){
            return (N) V1LimitRangeSpecFluentImpl.this.setToLimits(index, builder.build());
    }
    public N endLimit(){
            return and();
    }

}


}
