package io.kubernetes.client.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1LocalVolumeSourceFluentImpl<A extends V1LocalVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1LocalVolumeSourceFluent<A>{

    private String fsType;
    private String path;

    public V1LocalVolumeSourceFluentImpl(){
    }
    public V1LocalVolumeSourceFluentImpl(V1LocalVolumeSource instance){
            this.withFsType(instance.getFsType());

            this.withPath(instance.getPath());

    }

    public String getFsType(){
            return this.fsType;
    }

    public A withFsType(String fsType){
            this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType(){
            return this.fsType != null;
    }

    public A withNewFsType(String arg1){
            return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuilder arg1){
            return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuffer arg1){
            return (A)withFsType(new String(arg1));
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public Boolean hasPath(){
            return this.path != null;
    }

    public A withNewPath(String arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1){
            return (A)withPath(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1LocalVolumeSourceFluentImpl that = (V1LocalVolumeSourceFluentImpl) o;
            if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            return true;
    }




}
