package io.kubernetes.client.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1NFSVolumeSourceFluentImpl<A extends V1NFSVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1NFSVolumeSourceFluent<A>{

    private String path;
    private Boolean readOnly;
    private String server;

    public V1NFSVolumeSourceFluentImpl(){
    }
    public V1NFSVolumeSourceFluentImpl(V1NFSVolumeSource instance){
            this.withPath(instance.getPath());

            this.withReadOnly(instance.isReadOnly());

            this.withServer(instance.getServer());

    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public Boolean hasPath(){
            return this.path != null;
    }

    public A withNewPath(String arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1){
            return (A)withPath(new String(arg1));
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public String getServer(){
            return this.server;
    }

    public A withServer(String server){
            this.server=server; return (A) this;
    }

    public Boolean hasServer(){
            return this.server != null;
    }

    public A withNewServer(String arg1){
            return (A)withServer(new String(arg1));
    }

    public A withNewServer(StringBuilder arg1){
            return (A)withServer(new String(arg1));
    }

    public A withNewServer(StringBuffer arg1){
            return (A)withServer(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NFSVolumeSourceFluentImpl that = (V1NFSVolumeSourceFluentImpl) o;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (server != null ? !server.equals(that.server) :that.server != null) return false;
            return true;
    }




}
