package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PodAffinityBuilder extends V1PodAffinityFluentImpl<V1PodAffinityBuilder> implements VisitableBuilder<V1PodAffinity,V1PodAffinityBuilder>{

    V1PodAffinityFluent<?> fluent;
    Boolean validationEnabled;

    public V1PodAffinityBuilder(){
            this(true);
    }
    public V1PodAffinityBuilder(Boolean validationEnabled){
            this(new V1PodAffinity(), validationEnabled);
    }
    public V1PodAffinityBuilder(V1PodAffinityFluent<?> fluent){
            this(fluent, true);
    }
    public V1PodAffinityBuilder(V1PodAffinityFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PodAffinity(), validationEnabled);
    }
    public V1PodAffinityBuilder(V1PodAffinityFluent<?> fluent,V1PodAffinity instance){
            this(fluent, instance, true);
    }
    public V1PodAffinityBuilder(V1PodAffinityFluent<?> fluent,V1PodAffinity instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());

            fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());

            this.validationEnabled = validationEnabled; 
    }
    public V1PodAffinityBuilder(V1PodAffinity instance){
            this(instance,true);
    }
    public V1PodAffinityBuilder(V1PodAffinity instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());

            this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());

            this.validationEnabled = validationEnabled; 
    }

    public V1PodAffinity build(){
            V1PodAffinity buildable = new V1PodAffinity();
            buildable.setPreferredDuringSchedulingIgnoredDuringExecution(fluent.getPreferredDuringSchedulingIgnoredDuringExecution());
            buildable.setRequiredDuringSchedulingIgnoredDuringExecution(fluent.getRequiredDuringSchedulingIgnoredDuringExecution());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PodAffinityBuilder that = (V1PodAffinityBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
